@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Sms channel.
 * @property accountSID The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property authToken The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 * @property phone The Sms phone
 */
public data class SmsChannelPropertiesResponse(
    public val accountSID: String,
    public val authToken: String? = null,
    public val isEnabled: Boolean,
    public val isValidated: Boolean? = null,
    public val phone: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.SmsChannelPropertiesResponse):
            SmsChannelPropertiesResponse = SmsChannelPropertiesResponse(
            accountSID = javaType.accountSID(),
            authToken = javaType.authToken().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
            isValidated = javaType.isValidated().map({ args0 -> args0 }).orElse(null),
            phone = javaType.phone(),
        )
    }
}
