@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A telephone number for the Telephony channel
 * @property acsEndpoint The endpoint of ACS.
 * @property acsResourceId The resource id of ACS.
 * @property acsSecret The secret of ACS.
 * @property cognitiveServiceRegion The service region of cognitive service.
 * @property cognitiveServiceResourceId The resource id of cognitive service.
 * @property cognitiveServiceSubscriptionKey The subscription key of cognitive service.
 * @property defaultLocale The default locale of the phone number.
 * @property id The element id.
 * @property offerType Optional Property that will determine the offering type of the phone.
 * @property phoneNumber The phone number.
 */
public data class TelephonyPhoneNumbersResponse(
    public val acsEndpoint: String? = null,
    public val acsResourceId: String? = null,
    public val acsSecret: String? = null,
    public val cognitiveServiceRegion: String? = null,
    public val cognitiveServiceResourceId: String? = null,
    public val cognitiveServiceSubscriptionKey: String? = null,
    public val defaultLocale: String? = null,
    public val id: String? = null,
    public val offerType: String? = null,
    public val phoneNumber: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.TelephonyPhoneNumbersResponse):
            TelephonyPhoneNumbersResponse = TelephonyPhoneNumbersResponse(
            acsEndpoint = javaType.acsEndpoint().map({ args0 -> args0 }).orElse(null),
            acsResourceId = javaType.acsResourceId().map({ args0 -> args0 }).orElse(null),
            acsSecret = javaType.acsSecret().map({ args0 -> args0 }).orElse(null),
            cognitiveServiceRegion = javaType.cognitiveServiceRegion().map({ args0 -> args0 }).orElse(null),
            cognitiveServiceResourceId = javaType.cognitiveServiceResourceId().map({ args0 ->
                args0
            }).orElse(null),
            cognitiveServiceSubscriptionKey = javaType.cognitiveServiceSubscriptionKey().map({ args0 ->
                args0
            }).orElse(null),
            defaultLocale = javaType.defaultLocale().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            offerType = javaType.offerType().map({ args0 -> args0 }).orElse(null),
            phoneNumber = javaType.phoneNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
