@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.AccessPolicyAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Response to an operation on access policy assignment
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### RedisCacheAccessPolicyAssignmentCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicyAssignment = new AzureNative.Cache.AccessPolicyAssignment("accessPolicyAssignment", new()
 *     {
 *         AccessPolicyAssignmentName = "accessPolicyAssignmentName1",
 *         AccessPolicyName = "accessPolicy1",
 *         CacheName = "cache1",
 *         ObjectId = "6497c918-11ad-41e7-1b0f-7c518a87d0b0",
 *         ObjectIdAlias = "TestAADAppRedis",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewAccessPolicyAssignment(ctx, "accessPolicyAssignment", &cache.AccessPolicyAssignmentArgs{
 * 			AccessPolicyAssignmentName: pulumi.String("accessPolicyAssignmentName1"),
 * 			AccessPolicyName:           pulumi.String("accessPolicy1"),
 * 			CacheName:                  pulumi.String("cache1"),
 * 			ObjectId:                   pulumi.String("6497c918-11ad-41e7-1b0f-7c518a87d0b0"),
 * 			ObjectIdAlias:              pulumi.String("TestAADAppRedis"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.AccessPolicyAssignment;
 * import com.pulumi.azurenative.cache.AccessPolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicyAssignment = new AccessPolicyAssignment("accessPolicyAssignment", AccessPolicyAssignmentArgs.builder()
 *             .accessPolicyAssignmentName("accessPolicyAssignmentName1")
 *             .accessPolicyName("accessPolicy1")
 *             .cacheName("cache1")
 *             .objectId("6497c918-11ad-41e7-1b0f-7c518a87d0b0")
 *             .objectIdAlias("TestAADAppRedis")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:AccessPolicyAssignment accessPolicyAssignmentName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}
 * ```
 * @property accessPolicyAssignmentName The name of the access policy assignment.
 * @property accessPolicyName The name of the access policy that is being assigned
 * @property cacheName The name of the Redis cache.
 * @property objectId Object Id to assign access policy to
 * @property objectIdAlias User friendly name for object id. Also represents username for token based authentication
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class AccessPolicyAssignmentArgs(
    public val accessPolicyAssignmentName: Output<String>? = null,
    public val accessPolicyName: Output<String>? = null,
    public val cacheName: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val objectIdAlias: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.AccessPolicyAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.AccessPolicyAssignmentArgs =
        com.pulumi.azurenative.cache.AccessPolicyAssignmentArgs.builder()
            .accessPolicyAssignmentName(accessPolicyAssignmentName?.applyValue({ args0 -> args0 }))
            .accessPolicyName(accessPolicyName?.applyValue({ args0 -> args0 }))
            .cacheName(cacheName?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .objectIdAlias(objectIdAlias?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyAssignmentArgs].
 */
@PulumiTagMarker
public class AccessPolicyAssignmentArgsBuilder internal constructor() {
    private var accessPolicyAssignmentName: Output<String>? = null

    private var accessPolicyName: Output<String>? = null

    private var cacheName: Output<String>? = null

    private var objectId: Output<String>? = null

    private var objectIdAlias: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the access policy assignment.
     */
    @JvmName("cxeofnpgntbcljha")
    public suspend fun accessPolicyAssignmentName(`value`: Output<String>) {
        this.accessPolicyAssignmentName = value
    }

    /**
     * @param value The name of the access policy that is being assigned
     */
    @JvmName("uxjayaswpcmwkxub")
    public suspend fun accessPolicyName(`value`: Output<String>) {
        this.accessPolicyName = value
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("xtrswmjwgtxfhbeg")
    public suspend fun cacheName(`value`: Output<String>) {
        this.cacheName = value
    }

    /**
     * @param value Object Id to assign access policy to
     */
    @JvmName("pjnjyhwdooldsfpc")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value User friendly name for object id. Also represents username for token based authentication
     */
    @JvmName("wtbxywkbywyhcdex")
    public suspend fun objectIdAlias(`value`: Output<String>) {
        this.objectIdAlias = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jgdbylbnpaghhpbs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the access policy assignment.
     */
    @JvmName("ldqkpdwyhbfyvhua")
    public suspend fun accessPolicyAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicyAssignmentName = mapped
    }

    /**
     * @param value The name of the access policy that is being assigned
     */
    @JvmName("fnwoshrhccmicflh")
    public suspend fun accessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicyName = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("uefcwpsoliaxkmta")
    public suspend fun cacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheName = mapped
    }

    /**
     * @param value Object Id to assign access policy to
     */
    @JvmName("dvstumvpgatxdiif")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value User friendly name for object id. Also represents username for token based authentication
     */
    @JvmName("pcyvaoanxfsrpxiw")
    public suspend fun objectIdAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectIdAlias = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hoexkbvllhprmvos")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AccessPolicyAssignmentArgs = AccessPolicyAssignmentArgs(
        accessPolicyAssignmentName = accessPolicyAssignmentName,
        accessPolicyName = accessPolicyName,
        cacheName = cacheName,
        objectId = objectId,
        objectIdAlias = objectIdAlias,
        resourceGroupName = resourceGroupName,
    )
}
