@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.CacheFunctions.getAccessPolicyAssignmentPlain
import com.pulumi.azurenative.cache.CacheFunctions.getAccessPolicyPlain
import com.pulumi.azurenative.cache.CacheFunctions.getDatabasePlain
import com.pulumi.azurenative.cache.CacheFunctions.getEnterprisePrivateEndpointConnectionPlain
import com.pulumi.azurenative.cache.CacheFunctions.getFirewallRulePlain
import com.pulumi.azurenative.cache.CacheFunctions.getLinkedServerPlain
import com.pulumi.azurenative.cache.CacheFunctions.getPatchSchedulePlain
import com.pulumi.azurenative.cache.CacheFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.cache.CacheFunctions.getRedisEnterprisePlain
import com.pulumi.azurenative.cache.CacheFunctions.getRedisPlain
import com.pulumi.azurenative.cache.CacheFunctions.listDatabaseKeysPlain
import com.pulumi.azurenative.cache.CacheFunctions.listRedisKeysPlain
import com.pulumi.azurenative.cache.kotlin.inputs.GetAccessPolicyAssignmentPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetAccessPolicyAssignmentPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetAccessPolicyPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetAccessPolicyPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetDatabasePlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetDatabasePlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetEnterprisePrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetEnterprisePrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetFirewallRulePlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetLinkedServerPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetLinkedServerPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetPatchSchedulePlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetPatchSchedulePlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetRedisEnterprisePlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetRedisEnterprisePlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.GetRedisPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.GetRedisPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.ListDatabaseKeysPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ListDatabaseKeysPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.ListRedisKeysPlainArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ListRedisKeysPlainArgsBuilder
import com.pulumi.azurenative.cache.kotlin.outputs.GetAccessPolicyAssignmentResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetAccessPolicyResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetDatabaseResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetEnterprisePrivateEndpointConnectionResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetFirewallRuleResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetLinkedServerResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetPatchScheduleResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetRedisEnterpriseResult
import com.pulumi.azurenative.cache.kotlin.outputs.GetRedisResult
import com.pulumi.azurenative.cache.kotlin.outputs.ListDatabaseKeysResult
import com.pulumi.azurenative.cache.kotlin.outputs.ListRedisKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cache.kotlin.outputs.GetAccessPolicyAssignmentResult.Companion.toKotlin as getAccessPolicyAssignmentResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetAccessPolicyResult.Companion.toKotlin as getAccessPolicyResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetDatabaseResult.Companion.toKotlin as getDatabaseResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetEnterprisePrivateEndpointConnectionResult.Companion.toKotlin as getEnterprisePrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetFirewallRuleResult.Companion.toKotlin as getFirewallRuleResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetLinkedServerResult.Companion.toKotlin as getLinkedServerResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetPatchScheduleResult.Companion.toKotlin as getPatchScheduleResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetRedisEnterpriseResult.Companion.toKotlin as getRedisEnterpriseResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.GetRedisResult.Companion.toKotlin as getRedisResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.ListDatabaseKeysResult.Companion.toKotlin as listDatabaseKeysResultToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.ListRedisKeysResult.Companion.toKotlin as listRedisKeysResultToKotlin

public object CacheFunctions {
    /**
     * Gets the detailed information about an access policy of a redis cache
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-08-01.
     * @param argument null
     * @return Response to get/put access policy.
     */
    public suspend fun getAccessPolicy(argument: GetAccessPolicyPlainArgs): GetAccessPolicyResult =
        getAccessPolicyResultToKotlin(getAccessPolicyPlain(argument.toJava()).await())

    /**
     * @see [getAccessPolicy].
     * @param accessPolicyName The name of the access policy that is being added to the Redis cache.
     * @param cacheName The name of the Redis cache.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response to get/put access policy.
     */
    public suspend fun getAccessPolicy(
        accessPolicyName: String,
        cacheName: String,
        resourceGroupName: String,
    ): GetAccessPolicyResult {
        val argument = GetAccessPolicyPlainArgs(
            accessPolicyName = accessPolicyName,
            cacheName = cacheName,
            resourceGroupName = resourceGroupName,
        )
        return getAccessPolicyResultToKotlin(getAccessPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetAccessPolicyPlainArgs].
     * @return Response to get/put access policy.
     */
    public suspend fun getAccessPolicy(argument: suspend GetAccessPolicyPlainArgsBuilder.() -> Unit):
        GetAccessPolicyResult {
        val builder = GetAccessPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessPolicyResultToKotlin(getAccessPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the list of assignments for an access policy of a redis cache
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-08-01.
     * @param argument null
     * @return Response to an operation on access policy assignment
     */
    public suspend fun getAccessPolicyAssignment(argument: GetAccessPolicyAssignmentPlainArgs):
        GetAccessPolicyAssignmentResult =
        getAccessPolicyAssignmentResultToKotlin(getAccessPolicyAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getAccessPolicyAssignment].
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param cacheName The name of the Redis cache.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response to an operation on access policy assignment
     */
    public suspend fun getAccessPolicyAssignment(
        accessPolicyAssignmentName: String,
        cacheName: String,
        resourceGroupName: String,
    ): GetAccessPolicyAssignmentResult {
        val argument = GetAccessPolicyAssignmentPlainArgs(
            accessPolicyAssignmentName = accessPolicyAssignmentName,
            cacheName = cacheName,
            resourceGroupName = resourceGroupName,
        )
        return getAccessPolicyAssignmentResultToKotlin(getAccessPolicyAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessPolicyAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetAccessPolicyAssignmentPlainArgs].
     * @return Response to an operation on access policy assignment
     */
    public suspend
    fun getAccessPolicyAssignment(argument: suspend GetAccessPolicyAssignmentPlainArgsBuilder.() -> Unit):
        GetAccessPolicyAssignmentResult {
        val builder = GetAccessPolicyAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessPolicyAssignmentResultToKotlin(getAccessPolicyAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a database in a RedisEnterprise cluster.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
     * @param argument null
     * @return Describes a database on the RedisEnterprise cluster
     */
    public suspend fun getDatabase(argument: GetDatabasePlainArgs): GetDatabaseResult =
        getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())

    /**
     * @see [getDatabase].
     * @param clusterName The name of the RedisEnterprise cluster.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes a database on the RedisEnterprise cluster
     */
    public suspend fun getDatabase(
        clusterName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetDatabaseResult {
        val argument = GetDatabasePlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetDatabasePlainArgs].
     * @return Describes a database on the RedisEnterprise cluster
     */
    public suspend fun getDatabase(argument: suspend GetDatabasePlainArgsBuilder.() -> Unit):
        GetDatabaseResult {
        val builder = GetDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseResultToKotlin(getDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the RedisEnterprise cluster.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getEnterprisePrivateEndpointConnection(argument: GetEnterprisePrivateEndpointConnectionPlainArgs):
        GetEnterprisePrivateEndpointConnectionResult =
        getEnterprisePrivateEndpointConnectionResultToKotlin(getEnterprisePrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEnterprisePrivateEndpointConnection].
     * @param clusterName The name of the RedisEnterprise cluster.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getEnterprisePrivateEndpointConnection(
        clusterName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetEnterprisePrivateEndpointConnectionResult {
        val argument = GetEnterprisePrivateEndpointConnectionPlainArgs(
            clusterName = clusterName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getEnterprisePrivateEndpointConnectionResultToKotlin(getEnterprisePrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterprisePrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetEnterprisePrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getEnterprisePrivateEndpointConnection(argument: suspend GetEnterprisePrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetEnterprisePrivateEndpointConnectionResult {
        val builder = GetEnterprisePrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterprisePrivateEndpointConnectionResultToKotlin(getEnterprisePrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a single firewall rule in a specified redis cache.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-01-preview, 2023-08-01.
     * @param argument null
     * @return A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect
     */
    public suspend fun getFirewallRule(argument: GetFirewallRulePlainArgs): GetFirewallRuleResult =
        getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getFirewallRule].
     * @param cacheName The name of the Redis cache.
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the firewall rule.
     * @return A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect
     */
    public suspend fun getFirewallRule(
        cacheName: String,
        resourceGroupName: String,
        ruleName: String,
    ): GetFirewallRuleResult {
        val argument = GetFirewallRulePlainArgs(
            cacheName = cacheName,
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
        )
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetFirewallRulePlainArgs].
     * @return A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect
     */
    public suspend fun getFirewallRule(argument: suspend GetFirewallRulePlainArgsBuilder.() -> Unit):
        GetFirewallRuleResult {
        val builder = GetFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the detailed information about a linked server of a redis cache (requires Premium SKU).
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-01-preview, 2023-08-01.
     * @param argument null
     * @return Response to put/get linked server (with properties) for Redis cache.
     */
    public suspend fun getLinkedServer(argument: GetLinkedServerPlainArgs): GetLinkedServerResult =
        getLinkedServerResultToKotlin(getLinkedServerPlain(argument.toJava()).await())

    /**
     * @see [getLinkedServer].
     * @param linkedServerName The name of the linked server.
     * @param name The name of the redis cache.
     * @param resourceGroupName The name of the resource group.
     * @return Response to put/get linked server (with properties) for Redis cache.
     */
    public suspend fun getLinkedServer(
        linkedServerName: String,
        name: String,
        resourceGroupName: String,
    ): GetLinkedServerResult {
        val argument = GetLinkedServerPlainArgs(
            linkedServerName = linkedServerName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getLinkedServerResultToKotlin(getLinkedServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetLinkedServerPlainArgs].
     * @return Response to put/get linked server (with properties) for Redis cache.
     */
    public suspend fun getLinkedServer(argument: suspend GetLinkedServerPlainArgsBuilder.() -> Unit):
        GetLinkedServerResult {
        val builder = GetLinkedServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedServerResultToKotlin(getLinkedServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the patching schedule of a redis cache.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-01-preview, 2023-08-01.
     * @param argument null
     * @return Response to put/get patch schedules for Redis cache.
     */
    public suspend fun getPatchSchedule(argument: GetPatchSchedulePlainArgs): GetPatchScheduleResult =
        getPatchScheduleResultToKotlin(getPatchSchedulePlain(argument.toJava()).await())

    /**
     * @see [getPatchSchedule].
     * @param default Default string modeled as parameter for auto generation to work correctly.
     * @param name The name of the redis cache.
     * @param resourceGroupName The name of the resource group.
     * @return Response to put/get patch schedules for Redis cache.
     */
    public suspend fun getPatchSchedule(
        default: String,
        name: String,
        resourceGroupName: String,
    ): GetPatchScheduleResult {
        val argument = GetPatchSchedulePlainArgs(
            default = default,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getPatchScheduleResultToKotlin(getPatchSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPatchSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetPatchSchedulePlainArgs].
     * @return Response to put/get patch schedules for Redis cache.
     */
    public suspend
    fun getPatchSchedule(argument: suspend GetPatchSchedulePlainArgsBuilder.() -> Unit):
        GetPatchScheduleResult {
        val builder = GetPatchSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPatchScheduleResultToKotlin(getPatchSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the redis cache.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-01-preview, 2023-08-01.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param cacheName The name of the Redis cache.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        cacheName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            cacheName = cacheName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Redis cache (resource description).
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2015-08-01, 2017-02-01, 2019-07-01, 2020-06-01, 2023-05-01-preview, 2023-08-01.
     * @param argument null
     * @return A single Redis item in List or Get Operation.
     */
    public suspend fun getRedis(argument: GetRedisPlainArgs): GetRedisResult =
        getRedisResultToKotlin(getRedisPlain(argument.toJava()).await())

    /**
     * @see [getRedis].
     * @param name The name of the Redis cache.
     * @param resourceGroupName The name of the resource group.
     * @return A single Redis item in List or Get Operation.
     */
    public suspend fun getRedis(name: String, resourceGroupName: String): GetRedisResult {
        val argument = GetRedisPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getRedisResultToKotlin(getRedisPlain(argument.toJava()).await())
    }

    /**
     * @see [getRedis].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetRedisPlainArgs].
     * @return A single Redis item in List or Get Operation.
     */
    public suspend fun getRedis(argument: suspend GetRedisPlainArgsBuilder.() -> Unit):
        GetRedisResult {
        val builder = GetRedisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRedisResultToKotlin(getRedisPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a RedisEnterprise cluster
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2020-10-01-preview, 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
     * @param argument null
     * @return Describes the RedisEnterprise cluster
     */
    public suspend fun getRedisEnterprise(argument: GetRedisEnterprisePlainArgs):
        GetRedisEnterpriseResult =
        getRedisEnterpriseResultToKotlin(getRedisEnterprisePlain(argument.toJava()).await())

    /**
     * @see [getRedisEnterprise].
     * @param clusterName The name of the RedisEnterprise cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Describes the RedisEnterprise cluster
     */
    public suspend fun getRedisEnterprise(clusterName: String, resourceGroupName: String):
        GetRedisEnterpriseResult {
        val argument = GetRedisEnterprisePlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getRedisEnterpriseResultToKotlin(getRedisEnterprisePlain(argument.toJava()).await())
    }

    /**
     * @see [getRedisEnterprise].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;GetRedisEnterprisePlainArgs].
     * @return Describes the RedisEnterprise cluster
     */
    public suspend
    fun getRedisEnterprise(argument: suspend GetRedisEnterprisePlainArgsBuilder.() -> Unit):
        GetRedisEnterpriseResult {
        val builder = GetRedisEnterprisePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRedisEnterpriseResultToKotlin(getRedisEnterprisePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the access keys for the RedisEnterprise database.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
     * @param argument null
     * @return The secret access keys used for authenticating connections to redis
     */
    public suspend fun listDatabaseKeys(argument: ListDatabaseKeysPlainArgs): ListDatabaseKeysResult =
        listDatabaseKeysResultToKotlin(listDatabaseKeysPlain(argument.toJava()).await())

    /**
     * @see [listDatabaseKeys].
     * @param clusterName The name of the RedisEnterprise cluster.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The secret access keys used for authenticating connections to redis
     */
    public suspend fun listDatabaseKeys(
        clusterName: String,
        databaseName: String,
        resourceGroupName: String,
    ): ListDatabaseKeysResult {
        val argument = ListDatabaseKeysPlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return listDatabaseKeysResultToKotlin(listDatabaseKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listDatabaseKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;ListDatabaseKeysPlainArgs].
     * @return The secret access keys used for authenticating connections to redis
     */
    public suspend
    fun listDatabaseKeys(argument: suspend ListDatabaseKeysPlainArgsBuilder.() -> Unit):
        ListDatabaseKeysResult {
        val builder = ListDatabaseKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDatabaseKeysResultToKotlin(listDatabaseKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve a Redis cache's access keys. This operation requires write permission to the cache resource.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2015-08-01, 2017-02-01, 2019-07-01, 2020-06-01, 2023-05-01-preview, 2023-08-01.
     * @param argument null
     * @return Redis cache access keys.
     */
    public suspend fun listRedisKeys(argument: ListRedisKeysPlainArgs): ListRedisKeysResult =
        listRedisKeysResultToKotlin(listRedisKeysPlain(argument.toJava()).await())

    /**
     * @see [listRedisKeys].
     * @param name The name of the Redis cache.
     * @param resourceGroupName The name of the resource group.
     * @return Redis cache access keys.
     */
    public suspend fun listRedisKeys(name: String, resourceGroupName: String): ListRedisKeysResult {
        val argument = ListRedisKeysPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return listRedisKeysResultToKotlin(listRedisKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listRedisKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cache&#46;kotlin&#46;inputs&#46;ListRedisKeysPlainArgs].
     * @return Redis cache access keys.
     */
    public suspend fun listRedisKeys(argument: suspend ListRedisKeysPlainArgsBuilder.() -> Unit):
        ListRedisKeysResult {
        val builder = ListRedisKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRedisKeysResultToKotlin(listRedisKeysPlain(builtArgument.toJava()).await())
    }
}
