@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.DatabaseArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.ClusteringPolicy
import com.pulumi.azurenative.cache.kotlin.enums.EvictionPolicy
import com.pulumi.azurenative.cache.kotlin.enums.Protocol
import com.pulumi.azurenative.cache.kotlin.inputs.DatabasePropertiesGeoReplicationArgs
import com.pulumi.azurenative.cache.kotlin.inputs.DatabasePropertiesGeoReplicationArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.ModuleArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ModuleArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.PersistenceArgs
import com.pulumi.azurenative.cache.kotlin.inputs.PersistenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a database on the RedisEnterprise cluster
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
 * ## Example Usage
 * ### RedisEnterpriseDatabasesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Cache.Database("database", new()
 *     {
 *         ClientProtocol = "Encrypted",
 *         ClusterName = "cache1",
 *         ClusteringPolicy = "EnterpriseCluster",
 *         DatabaseName = "default",
 *         EvictionPolicy = "AllKeysLRU",
 *         Modules = new[]
 *         {
 *             new AzureNative.Cache.Inputs.ModuleArgs
 *             {
 *                 Args = "ERROR_RATE 0.00 INITIAL_SIZE 400",
 *                 Name = "RedisBloom",
 *             },
 *             new AzureNative.Cache.Inputs.ModuleArgs
 *             {
 *                 Args = "RETENTION_POLICY 20",
 *                 Name = "RedisTimeSeries",
 *             },
 *             new AzureNative.Cache.Inputs.ModuleArgs
 *             {
 *                 Name = "RediSearch",
 *             },
 *         },
 *         Persistence = new AzureNative.Cache.Inputs.PersistenceArgs
 *         {
 *             AofEnabled = true,
 *             AofFrequency = "1s",
 *         },
 *         Port = 10000,
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewDatabase(ctx, "database", &cache.DatabaseArgs{
 * 			ClientProtocol:   pulumi.String("Encrypted"),
 * 			ClusterName:      pulumi.String("cache1"),
 * 			ClusteringPolicy: pulumi.String("EnterpriseCluster"),
 * 			DatabaseName:     pulumi.String("default"),
 * 			EvictionPolicy:   pulumi.String("AllKeysLRU"),
 * 			Modules: []cache.ModuleArgs{
 * 				{
 * 					Args: pulumi.String("ERROR_RATE 0.00 INITIAL_SIZE 400"),
 * 					Name: pulumi.String("RedisBloom"),
 * 				},
 * 				{
 * 					Args: pulumi.String("RETENTION_POLICY 20"),
 * 					Name: pulumi.String("RedisTimeSeries"),
 * 				},
 * 				{
 * 					Name: pulumi.String("RediSearch"),
 * 				},
 * 			},
 * 			Persistence: &cache.PersistenceArgs{
 * 				AofEnabled:   pulumi.Bool(true),
 * 				AofFrequency: pulumi.String("1s"),
 * 			},
 * 			Port:              pulumi.Int(10000),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Database;
 * import com.pulumi.azurenative.cache.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .clientProtocol("Encrypted")
 *             .clusterName("cache1")
 *             .clusteringPolicy("EnterpriseCluster")
 *             .databaseName("default")
 *             .evictionPolicy("AllKeysLRU")
 *             .modules(
 *                 Map.ofEntries(
 *                     Map.entry("args", "ERROR_RATE 0.00 INITIAL_SIZE 400"),
 *                     Map.entry("name", "RedisBloom")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("args", "RETENTION_POLICY 20"),
 *                     Map.entry("name", "RedisTimeSeries")
 *                 ),
 *                 Map.of("name", "RediSearch"))
 *             .persistence(Map.ofEntries(
 *                 Map.entry("aofEnabled", true),
 *                 Map.entry("aofFrequency", "1s")
 *             ))
 *             .port(10000)
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### RedisEnterpriseDatabasesCreate With Active Geo Replication
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Cache.Database("database", new()
 *     {
 *         ClientProtocol = "Encrypted",
 *         ClusterName = "cache1",
 *         ClusteringPolicy = "EnterpriseCluster",
 *         DatabaseName = "default",
 *         EvictionPolicy = "NoEviction",
 *         GeoReplication = new AzureNative.Cache.Inputs.DatabasePropertiesGeoReplicationArgs
 *         {
 *             GroupNickname = "groupName",
 *             LinkedDatabases = new[]
 *             {
 *                 new AzureNative.Cache.Inputs.LinkedDatabaseArgs
 *                 {
 *                     Id = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Cache/redisEnterprise/cache1/databases/default",
 *                 },
 *                 new AzureNative.Cache.Inputs.LinkedDatabaseArgs
 *                 {
 *                     Id = "/subscriptions/subid2/resourceGroups/rg2/providers/Microsoft.Cache/redisEnterprise/cache2/databases/default",
 *                 },
 *             },
 *         },
 *         Port = 10000,
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewDatabase(ctx, "database", &cache.DatabaseArgs{
 * 			ClientProtocol:   pulumi.String("Encrypted"),
 * 			ClusterName:      pulumi.String("cache1"),
 * 			ClusteringPolicy: pulumi.String("EnterpriseCluster"),
 * 			DatabaseName:     pulumi.String("default"),
 * 			EvictionPolicy:   pulumi.String("NoEviction"),
 * 			GeoReplication: cache.DatabasePropertiesResponseGeoReplication{
 * 				GroupNickname: pulumi.String("groupName"),
 * 				LinkedDatabases: cache.LinkedDatabaseArray{
 * 					&cache.LinkedDatabaseArgs{
 * 						Id: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Cache/redisEnterprise/cache1/databases/default"),
 * 					},
 * 					&cache.LinkedDatabaseArgs{
 * 						Id: pulumi.String("/subscriptions/subid2/resourceGroups/rg2/providers/Microsoft.Cache/redisEnterprise/cache2/databases/default"),
 * 					},
 * 				},
 * 			},
 * 			Port:              pulumi.Int(10000),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Database;
 * import com.pulumi.azurenative.cache.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .clientProtocol("Encrypted")
 *             .clusterName("cache1")
 *             .clusteringPolicy("EnterpriseCluster")
 *             .databaseName("default")
 *             .evictionPolicy("NoEviction")
 *             .geoReplication(Map.ofEntries(
 *                 Map.entry("groupNickname", "groupName"),
 *                 Map.entry("linkedDatabases",
 *                     Map.of("id", "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Cache/redisEnterprise/cache1/databases/default"),
 *                     Map.of("id", "/subscriptions/subid2/resourceGroups/rg2/providers/Microsoft.Cache/redisEnterprise/cache2/databases/default"))
 *             ))
 *             .port(10000)
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:Database cache1/default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/databases/{databaseName}
 * ```
 * @property clientProtocol Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
 * @property clusterName The name of the RedisEnterprise cluster.
 * @property clusteringPolicy Clustering policy - default is OSSCluster. Specified at create time.
 * @property databaseName The name of the database.
 * @property evictionPolicy Redis eviction policy - default is VolatileLRU
 * @property geoReplication Optional set of properties to configure geo replication for this database.
 * @property modules Optional set of redis modules to enable in this database - modules can only be added at creation time.
 * @property persistence Persistence settings
 * @property port TCP port of the database endpoint. Specified at create time. Defaults to an available port.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DatabaseArgs(
    public val clientProtocol: Output<Either<String, Protocol>>? = null,
    public val clusterName: Output<String>? = null,
    public val clusteringPolicy: Output<Either<String, ClusteringPolicy>>? = null,
    public val databaseName: Output<String>? = null,
    public val evictionPolicy: Output<Either<String, EvictionPolicy>>? = null,
    public val geoReplication: Output<DatabasePropertiesGeoReplicationArgs>? = null,
    public val modules: Output<List<ModuleArgs>>? = null,
    public val persistence: Output<PersistenceArgs>? = null,
    public val port: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.DatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.DatabaseArgs =
        com.pulumi.azurenative.cache.DatabaseArgs.builder()
            .clientProtocol(
                clientProtocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusteringPolicy(
                clusteringPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .evictionPolicy(
                evictionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .geoReplication(geoReplication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modules(
                modules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .persistence(persistence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseArgs].
 */
@PulumiTagMarker
public class DatabaseArgsBuilder internal constructor() {
    private var clientProtocol: Output<Either<String, Protocol>>? = null

    private var clusterName: Output<String>? = null

    private var clusteringPolicy: Output<Either<String, ClusteringPolicy>>? = null

    private var databaseName: Output<String>? = null

    private var evictionPolicy: Output<Either<String, EvictionPolicy>>? = null

    private var geoReplication: Output<DatabasePropertiesGeoReplicationArgs>? = null

    private var modules: Output<List<ModuleArgs>>? = null

    private var persistence: Output<PersistenceArgs>? = null

    private var port: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
     */
    @JvmName("xfmfxfdnxtgywlij")
    public suspend fun clientProtocol(`value`: Output<Either<String, Protocol>>) {
        this.clientProtocol = value
    }

    /**
     * @param value The name of the RedisEnterprise cluster.
     */
    @JvmName("quoswxsrqjxkgyao")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Clustering policy - default is OSSCluster. Specified at create time.
     */
    @JvmName("fnsibqorrkaqijva")
    public suspend fun clusteringPolicy(`value`: Output<Either<String, ClusteringPolicy>>) {
        this.clusteringPolicy = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("jvfexvuyjlfxkhgd")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Redis eviction policy - default is VolatileLRU
     */
    @JvmName("wigjfyrpxdmjtsem")
    public suspend fun evictionPolicy(`value`: Output<Either<String, EvictionPolicy>>) {
        this.evictionPolicy = value
    }

    /**
     * @param value Optional set of properties to configure geo replication for this database.
     */
    @JvmName("frwkaioktcgbsdyu")
    public suspend fun geoReplication(`value`: Output<DatabasePropertiesGeoReplicationArgs>) {
        this.geoReplication = value
    }

    /**
     * @param value Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("awuturgriauefvwk")
    public suspend fun modules(`value`: Output<List<ModuleArgs>>) {
        this.modules = value
    }

    @JvmName("lygmohduscefsxfl")
    public suspend fun modules(vararg values: Output<ModuleArgs>) {
        this.modules = Output.all(values.asList())
    }

    /**
     * @param values Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("qwcysunudbkpppss")
    public suspend fun modules(values: List<Output<ModuleArgs>>) {
        this.modules = Output.all(values)
    }

    /**
     * @param value Persistence settings
     */
    @JvmName("lwhqnfyiwtvutvpn")
    public suspend fun persistence(`value`: Output<PersistenceArgs>) {
        this.persistence = value
    }

    /**
     * @param value TCP port of the database endpoint. Specified at create time. Defaults to an available port.
     */
    @JvmName("aklqfyvwaftpyjyr")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ajejtuggblbkmwcl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
     */
    @JvmName("qiyrctutbojpyjct")
    public suspend fun clientProtocol(`value`: Either<String, Protocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientProtocol = mapped
    }

    /**
     * @param value Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
     */
    @JvmName("hkhblamweaulhxvi")
    public fun clientProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientProtocol = mapped
    }

    /**
     * @param value Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
     */
    @JvmName("pblorwmyehgoqhuc")
    public fun clientProtocol(`value`: Protocol) {
        val toBeMapped = Either.ofRight<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientProtocol = mapped
    }

    /**
     * @param value The name of the RedisEnterprise cluster.
     */
    @JvmName("hqvibtpkithfvjnk")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Clustering policy - default is OSSCluster. Specified at create time.
     */
    @JvmName("okigljfbhbaknlvd")
    public suspend fun clusteringPolicy(`value`: Either<String, ClusteringPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusteringPolicy = mapped
    }

    /**
     * @param value Clustering policy - default is OSSCluster. Specified at create time.
     */
    @JvmName("asundtukgvhvjvhf")
    public fun clusteringPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusteringPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusteringPolicy = mapped
    }

    /**
     * @param value Clustering policy - default is OSSCluster. Specified at create time.
     */
    @JvmName("clnacdoddydvdswu")
    public fun clusteringPolicy(`value`: ClusteringPolicy) {
        val toBeMapped = Either.ofRight<String, ClusteringPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusteringPolicy = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("xmerewfcdiuhgjkf")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Redis eviction policy - default is VolatileLRU
     */
    @JvmName("puiyvxtrtnwpolns")
    public suspend fun evictionPolicy(`value`: Either<String, EvictionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Redis eviction policy - default is VolatileLRU
     */
    @JvmName("khrxqmppdmwmljrw")
    public fun evictionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EvictionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Redis eviction policy - default is VolatileLRU
     */
    @JvmName("bqdgyhgssrkoosgl")
    public fun evictionPolicy(`value`: EvictionPolicy) {
        val toBeMapped = Either.ofRight<String, EvictionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Optional set of properties to configure geo replication for this database.
     */
    @JvmName("opfmnduxkrjlpigc")
    public suspend fun geoReplication(`value`: DatabasePropertiesGeoReplicationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoReplication = mapped
    }

    /**
     * @param argument Optional set of properties to configure geo replication for this database.
     */
    @JvmName("vtdlirvdxdjydtrd")
    public suspend
    fun geoReplication(argument: suspend DatabasePropertiesGeoReplicationArgsBuilder.() -> Unit) {
        val toBeMapped = DatabasePropertiesGeoReplicationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.geoReplication = mapped
    }

    /**
     * @param value Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("wqybhoqyddbtpvew")
    public suspend fun modules(`value`: List<ModuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modules = mapped
    }

    /**
     * @param argument Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("gxwfysriytywviyr")
    public suspend fun modules(argument: List<suspend ModuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ModuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.modules = mapped
    }

    /**
     * @param argument Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("thtukqqcvvmivtxq")
    public suspend fun modules(vararg argument: suspend ModuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ModuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.modules = mapped
    }

    /**
     * @param argument Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("yswjyfijvmvmkamn")
    public suspend fun modules(argument: suspend ModuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ModuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.modules = mapped
    }

    /**
     * @param values Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    @JvmName("rkylpfxrwngbccxq")
    public suspend fun modules(vararg values: ModuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modules = mapped
    }

    /**
     * @param value Persistence settings
     */
    @JvmName("rrhgtxuulbwsrxjl")
    public suspend fun persistence(`value`: PersistenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistence = mapped
    }

    /**
     * @param argument Persistence settings
     */
    @JvmName("atiqcfslsoobrrea")
    public suspend fun persistence(argument: suspend PersistenceArgsBuilder.() -> Unit) {
        val toBeMapped = PersistenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.persistence = mapped
    }

    /**
     * @param value TCP port of the database endpoint. Specified at create time. Defaults to an available port.
     */
    @JvmName("ustkdfsdxagfkyjs")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("octooskfsyxlflcm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DatabaseArgs = DatabaseArgs(
        clientProtocol = clientProtocol,
        clusterName = clusterName,
        clusteringPolicy = clusteringPolicy,
        databaseName = databaseName,
        evictionPolicy = evictionPolicy,
        geoReplication = geoReplication,
        modules = modules,
        persistence = persistence,
        port = port,
        resourceGroupName = resourceGroupName,
    )
}
