@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EnterprisePrivateEndpointConnection].
 */
@PulumiTagMarker
public class EnterprisePrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterprisePrivateEndpointConnectionArgs =
        EnterprisePrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend EnterprisePrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = EnterprisePrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EnterprisePrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.cache.EnterprisePrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnterprisePrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
 * ## Example Usage
 * ### RedisEnterprisePutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enterprisePrivateEndpointConnection = new AzureNative.Cache.EnterprisePrivateEndpointConnection("enterprisePrivateEndpointConnection", new()
 *     {
 *         ClusterName = "cache1",
 *         PrivateEndpointConnectionName = "pectest01",
 *         PrivateLinkServiceConnectionState = new AzureNative.Cache.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewEnterprisePrivateEndpointConnection(ctx, "enterprisePrivateEndpointConnection", &cache.EnterprisePrivateEndpointConnectionArgs{
 * 			ClusterName:                   pulumi.String("cache1"),
 * 			PrivateEndpointConnectionName: pulumi.String("pectest01"),
 * 			PrivateLinkServiceConnectionState: &cache.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.EnterprisePrivateEndpointConnection;
 * import com.pulumi.azurenative.cache.EnterprisePrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enterprisePrivateEndpointConnection = new EnterprisePrivateEndpointConnection("enterprisePrivateEndpointConnection", EnterprisePrivateEndpointConnectionArgs.builder()
 *             .clusterName("cache1")
 *             .privateEndpointConnectionName("pectest01")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Auto-Approved"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:EnterprisePrivateEndpointConnection pectest01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class EnterprisePrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.EnterprisePrivateEndpointConnection,
) : KotlinCustomResource(javaResource, EnterprisePrivateEndpointConnectionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnterprisePrivateEndpointConnectionMapper :
    ResourceMapper<EnterprisePrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.EnterprisePrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): EnterprisePrivateEndpointConnection =
        EnterprisePrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.cache.EnterprisePrivateEndpointConnection,
        )
}

/**
 * @see [EnterprisePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterprisePrivateEndpointConnection].
 */
public suspend fun enterprisePrivateEndpointConnection(
    name: String,
    block: suspend EnterprisePrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    EnterprisePrivateEndpointConnection {
    val builder = EnterprisePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterprisePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterprisePrivateEndpointConnection(name: String): EnterprisePrivateEndpointConnection {
    val builder = EnterprisePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
