@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.RedisEnterpriseArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.TlsVersion
import com.pulumi.azurenative.cache.kotlin.inputs.ClusterPropertiesEncryptionArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ClusterPropertiesEncryptionArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.EnterpriseSkuArgs
import com.pulumi.azurenative.cache.kotlin.inputs.EnterpriseSkuArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes the RedisEnterprise cluster
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2020-10-01-preview, 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:RedisEnterprise cache1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}
 * ```
 * @property clusterName The name of the RedisEnterprise cluster.
 * @property encryption Encryption-at-rest configuration for the cluster.
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property minimumTlsVersion The minimum TLS version for the cluster to support, e.g. '1.2'
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU to create, which affects price, performance, and features.
 * @property tags Resource tags.
 * @property zones The Availability Zones where this cluster will be deployed.
 */
public data class RedisEnterpriseArgs(
    public val clusterName: Output<String>? = null,
    public val encryption: Output<ClusterPropertiesEncryptionArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersion: Output<Either<String, TlsVersion>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<EnterpriseSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.RedisEnterpriseArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.RedisEnterpriseArgs =
        com.pulumi.azurenative.cache.RedisEnterpriseArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RedisEnterpriseArgs].
 */
@PulumiTagMarker
public class RedisEnterpriseArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var encryption: Output<ClusterPropertiesEncryptionArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersion: Output<Either<String, TlsVersion>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<EnterpriseSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The name of the RedisEnterprise cluster.
     */
    @JvmName("cyjmbiysojnvybwm")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Encryption-at-rest configuration for the cluster.
     */
    @JvmName("oxtrelwgmmmjkxyu")
    public suspend fun encryption(`value`: Output<ClusterPropertiesEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("penclscfunkcxeuo")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("juvaaclwyddratvm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("qqrhoynvhlhqfpql")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, TlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jsxqfntffvrbsxof")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU to create, which affects price, performance, and features.
     */
    @JvmName("glntmtmlndnbbghq")
    public suspend fun sku(`value`: Output<EnterpriseSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sihuqajcbpehudxc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Availability Zones where this cluster will be deployed.
     */
    @JvmName("gslmoucswhdutgio")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("dyflnaevfcjshwsg")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The Availability Zones where this cluster will be deployed.
     */
    @JvmName("juwxduaiqpuodskt")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The name of the RedisEnterprise cluster.
     */
    @JvmName("wsrajmxbhyicnmcp")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Encryption-at-rest configuration for the cluster.
     */
    @JvmName("perqwalbgyiuwysn")
    public suspend fun encryption(`value`: ClusterPropertiesEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption-at-rest configuration for the cluster.
     */
    @JvmName("qvoqxvncytejbwjn")
    public suspend
    fun encryption(argument: suspend ClusterPropertiesEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPropertiesEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("rkfwlwamfiklwcrb")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("vogiwrysvuwjgwuk")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kidnmmpunhrivhyl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("tyqxwoldbrvdjhid")
    public suspend fun minimumTlsVersion(`value`: Either<String, TlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("utfimnwryhbmkwpw")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("pfsxqynylbxxnxug")
    public fun minimumTlsVersion(`value`: TlsVersion) {
        val toBeMapped = Either.ofRight<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("euxoavfgpkkavmjb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU to create, which affects price, performance, and features.
     */
    @JvmName("euakjxrekjfuiokd")
    public suspend fun sku(`value`: EnterpriseSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU to create, which affects price, performance, and features.
     */
    @JvmName("vvyhlyadnbynvruw")
    public suspend fun sku(argument: suspend EnterpriseSkuArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jtqpvfphuoptaorg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nalntnvbpbjpkgiv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Availability Zones where this cluster will be deployed.
     */
    @JvmName("wgihhnvyuxxkcxks")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The Availability Zones where this cluster will be deployed.
     */
    @JvmName("hfaelsmrugyuqauh")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): RedisEnterpriseArgs = RedisEnterpriseArgs(
        clusterName = clusterName,
        encryption = encryption,
        identity = identity,
        location = location,
        minimumTlsVersion = minimumTlsVersion,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
