@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of RedisEnterprise cluster to deploy. Possible values: (Enterprise_E10, EnterpriseFlash_F300 etc.)
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.cache.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.cache.enums.SkuName> {
    Enterprise_E10(com.pulumi.azurenative.cache.enums.SkuName.Enterprise_E10),
    Enterprise_E20(com.pulumi.azurenative.cache.enums.SkuName.Enterprise_E20),
    Enterprise_E50(com.pulumi.azurenative.cache.enums.SkuName.Enterprise_E50),
    Enterprise_E100(com.pulumi.azurenative.cache.enums.SkuName.Enterprise_E100),
    EnterpriseFlash_F300(com.pulumi.azurenative.cache.enums.SkuName.EnterpriseFlash_F300),
    EnterpriseFlash_F700(com.pulumi.azurenative.cache.enums.SkuName.EnterpriseFlash_F700),
    EnterpriseFlash_F1500(com.pulumi.azurenative.cache.enums.SkuName.EnterpriseFlash_F1500),
    ;

    override fun toJava(): com.pulumi.azurenative.cache.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
