@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.DatabasePropertiesGeoReplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Optional set of properties to configure geo replication for this database.
 * @property groupNickname Name for the group of linked database resources
 * @property linkedDatabases List of database resources to link with this database
 */
public data class DatabasePropertiesGeoReplicationArgs(
    public val groupNickname: Output<String>? = null,
    public val linkedDatabases: Output<List<LinkedDatabaseArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.DatabasePropertiesGeoReplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.DatabasePropertiesGeoReplicationArgs =
        com.pulumi.azurenative.cache.inputs.DatabasePropertiesGeoReplicationArgs.builder()
            .groupNickname(groupNickname?.applyValue({ args0 -> args0 }))
            .linkedDatabases(
                linkedDatabases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DatabasePropertiesGeoReplicationArgs].
 */
@PulumiTagMarker
public class DatabasePropertiesGeoReplicationArgsBuilder internal constructor() {
    private var groupNickname: Output<String>? = null

    private var linkedDatabases: Output<List<LinkedDatabaseArgs>>? = null

    /**
     * @param value Name for the group of linked database resources
     */
    @JvmName("tdqpanttkvxkstmq")
    public suspend fun groupNickname(`value`: Output<String>) {
        this.groupNickname = value
    }

    /**
     * @param value List of database resources to link with this database
     */
    @JvmName("vmtpybqplcqwvomr")
    public suspend fun linkedDatabases(`value`: Output<List<LinkedDatabaseArgs>>) {
        this.linkedDatabases = value
    }

    @JvmName("yrrikasqlpgitawj")
    public suspend fun linkedDatabases(vararg values: Output<LinkedDatabaseArgs>) {
        this.linkedDatabases = Output.all(values.asList())
    }

    /**
     * @param values List of database resources to link with this database
     */
    @JvmName("aegqblppteucaekq")
    public suspend fun linkedDatabases(values: List<Output<LinkedDatabaseArgs>>) {
        this.linkedDatabases = Output.all(values)
    }

    /**
     * @param value Name for the group of linked database resources
     */
    @JvmName("kbxysqevfeewyjll")
    public suspend fun groupNickname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupNickname = mapped
    }

    /**
     * @param value List of database resources to link with this database
     */
    @JvmName("emkoosmtdmjxinog")
    public suspend fun linkedDatabases(`value`: List<LinkedDatabaseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedDatabases = mapped
    }

    /**
     * @param argument List of database resources to link with this database
     */
    @JvmName("nirmhwdyidiblbbh")
    public suspend fun linkedDatabases(argument: List<suspend LinkedDatabaseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedDatabaseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedDatabases = mapped
    }

    /**
     * @param argument List of database resources to link with this database
     */
    @JvmName("hhkkxrmqgihjvpso")
    public suspend fun linkedDatabases(
        vararg
        argument: suspend LinkedDatabaseArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedDatabaseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedDatabases = mapped
    }

    /**
     * @param argument List of database resources to link with this database
     */
    @JvmName("byoawxhdbouclrsj")
    public suspend fun linkedDatabases(argument: suspend LinkedDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedDatabaseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedDatabases = mapped
    }

    /**
     * @param values List of database resources to link with this database
     */
    @JvmName("scbqnpuswyphpxbq")
    public suspend fun linkedDatabases(vararg values: LinkedDatabaseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedDatabases = mapped
    }

    internal fun build(): DatabasePropertiesGeoReplicationArgs = DatabasePropertiesGeoReplicationArgs(
        groupNickname = groupNickname,
        linkedDatabases = linkedDatabases,
    )
}
