@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.GetPatchSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property default Default string modeled as parameter for auto generation to work correctly.
 * @property name The name of the redis cache.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPatchSchedulePlainArgs(
    public val default: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.GetPatchSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.GetPatchSchedulePlainArgs =
        com.pulumi.azurenative.cache.inputs.GetPatchSchedulePlainArgs.builder()
            .default_(default.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPatchSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetPatchSchedulePlainArgsBuilder internal constructor() {
    private var default: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Default string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("umymqypjunuoyice")
    public suspend fun default(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.default = mapped
    }

    /**
     * @param value The name of the redis cache.
     */
    @JvmName("ojcgkmoxcgyvssbo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fqpllprhjialglkk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPatchSchedulePlainArgs = GetPatchSchedulePlainArgs(
        default = default ?: throw PulumiNullFieldException("default"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
