@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.LinkedDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies details of a linked database resource.
 * @property id Resource ID of a database resource to link with this database.
 */
public data class LinkedDatabaseArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.LinkedDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.LinkedDatabaseArgs =
        com.pulumi.azurenative.cache.inputs.LinkedDatabaseArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedDatabaseArgs].
 */
@PulumiTagMarker
public class LinkedDatabaseArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of a database resource to link with this database.
     */
    @JvmName("pecnepydadqjgcwv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of a database resource to link with this database.
     */
    @JvmName("wcpmumiqywwcxssh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): LinkedDatabaseArgs = LinkedDatabaseArgs(
        id = id,
    )
}
