@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.ListDatabaseKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the RedisEnterprise cluster.
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListDatabaseKeysPlainArgs(
    public val clusterName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.ListDatabaseKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.ListDatabaseKeysPlainArgs =
        com.pulumi.azurenative.cache.inputs.ListDatabaseKeysPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDatabaseKeysPlainArgs].
 */
@PulumiTagMarker
public class ListDatabaseKeysPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the RedisEnterprise cluster.
     */
    @JvmName("ypytwqhhprdxjqyx")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("lwfepcqffyyhpufc")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gtpxrtvooqsubcpq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListDatabaseKeysPlainArgs = ListDatabaseKeysPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
