@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Response to get/put access policy.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property permissions Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
 * @property provisioningState Provisioning state of access policy
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAccessPolicyResult(
    public val id: String,
    public val name: String,
    public val permissions: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetAccessPolicyResult):
            GetAccessPolicyResult = GetAccessPolicyResult(
            id = javaType.id(),
            name = javaType.name(),
            permissions = javaType.permissions(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
