@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect
 * @property endIP highest IP address included in the range
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property startIP lowest IP address included in the range
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFirewallRuleResult(
    public val endIP: String,
    public val id: String,
    public val name: String,
    public val startIP: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetFirewallRuleResult):
            GetFirewallRuleResult = GetFirewallRuleResult(
            endIP = javaType.endIP(),
            id = javaType.id(),
            name = javaType.name(),
            startIP = javaType.startIP(),
            type = javaType.type(),
        )
    }
}
