@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.AFDOriginGroupArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.EnabledState
import com.pulumi.azurenative.cdn.kotlin.inputs.HealthProbeParametersArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.HealthProbeParametersArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.LoadBalancingSettingsParametersArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.LoadBalancingSettingsParametersArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from Azure Front Door.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01, 2023-07-01-preview.
 * ## Example Usage
 * ### AFDOriginGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdOriginGroup = new AzureNative.Cdn.AFDOriginGroup("afdOriginGroup", new()
 *     {
 *         HealthProbeSettings = new AzureNative.Cdn.Inputs.HealthProbeParametersArgs
 *         {
 *             ProbeIntervalInSeconds = 10,
 *             ProbePath = "/path2",
 *             ProbeProtocol = AzureNative.Cdn.ProbeProtocol.NotSet,
 *             ProbeRequestType = AzureNative.Cdn.HealthProbeRequestType.NotSet,
 *         },
 *         LoadBalancingSettings = new AzureNative.Cdn.Inputs.LoadBalancingSettingsParametersArgs
 *         {
 *             AdditionalLatencyInMilliseconds = 1000,
 *             SampleSize = 3,
 *             SuccessfulSamplesRequired = 3,
 *         },
 *         OriginGroupName = "origingroup1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         TrafficRestorationTimeToHealedOrNewEndpointsInMinutes = 5,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDOriginGroup(ctx, "afdOriginGroup", &cdn.AFDOriginGroupArgs{
 * 			HealthProbeSettings: &cdn.HealthProbeParametersArgs{
 * 				ProbeIntervalInSeconds: pulumi.Int(10),
 * 				ProbePath:              pulumi.String("/path2"),
 * 				ProbeProtocol:          cdn.ProbeProtocolNotSet,
 * 				ProbeRequestType:       cdn.HealthProbeRequestTypeNotSet,
 * 			},
 * 			LoadBalancingSettings: &cdn.LoadBalancingSettingsParametersArgs{
 * 				AdditionalLatencyInMilliseconds: pulumi.Int(1000),
 * 				SampleSize:                      pulumi.Int(3),
 * 				SuccessfulSamplesRequired:       pulumi.Int(3),
 * 			},
 * 			OriginGroupName:   pulumi.String("origingroup1"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			TrafficRestorationTimeToHealedOrNewEndpointsInMinutes: pulumi.Int(5),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDOriginGroup;
 * import com.pulumi.azurenative.cdn.AFDOriginGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdOriginGroup = new AFDOriginGroup("afdOriginGroup", AFDOriginGroupArgs.builder()
 *             .healthProbeSettings(Map.ofEntries(
 *                 Map.entry("probeIntervalInSeconds", 10),
 *                 Map.entry("probePath", "/path2"),
 *                 Map.entry("probeProtocol", "NotSet"),
 *                 Map.entry("probeRequestType", "NotSet")
 *             ))
 *             .loadBalancingSettings(Map.ofEntries(
 *                 Map.entry("additionalLatencyInMilliseconds", 1000),
 *                 Map.entry("sampleSize", 3),
 *                 Map.entry("successfulSamplesRequired", 3)
 *             ))
 *             .originGroupName("origingroup1")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .trafficRestorationTimeToHealedOrNewEndpointsInMinutes(5)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDOriginGroup origingroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}
 * ```
 * @property healthProbeSettings Health probe settings to the origin that is used to determine the health of the origin.
 * @property loadBalancingSettings Load balancing settings for a backend pool
 * @property originGroupName Name of the origin group which is unique within the endpoint.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property sessionAffinityState Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
 * @property trafficRestorationTimeToHealedOrNewEndpointsInMinutes Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
 */
public data class AFDOriginGroupArgs(
    public val healthProbeSettings: Output<HealthProbeParametersArgs>? = null,
    public val loadBalancingSettings: Output<LoadBalancingSettingsParametersArgs>? = null,
    public val originGroupName: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sessionAffinityState: Output<Either<String, EnabledState>>? = null,
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.AFDOriginGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.AFDOriginGroupArgs =
        com.pulumi.azurenative.cdn.AFDOriginGroupArgs.builder()
            .healthProbeSettings(
                healthProbeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .loadBalancingSettings(
                loadBalancingSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .originGroupName(originGroupName?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sessionAffinityState(
                sessionAffinityState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .trafficRestorationTimeToHealedOrNewEndpointsInMinutes(
                trafficRestorationTimeToHealedOrNewEndpointsInMinutes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [AFDOriginGroupArgs].
 */
@PulumiTagMarker
public class AFDOriginGroupArgsBuilder internal constructor() {
    private var healthProbeSettings: Output<HealthProbeParametersArgs>? = null

    private var loadBalancingSettings: Output<LoadBalancingSettingsParametersArgs>? = null

    private var originGroupName: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sessionAffinityState: Output<Either<String, EnabledState>>? = null

    private var trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>? = null

    /**
     * @param value Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("oepkpeafnfdjntem")
    public suspend fun healthProbeSettings(`value`: Output<HealthProbeParametersArgs>) {
        this.healthProbeSettings = value
    }

    /**
     * @param value Load balancing settings for a backend pool
     */
    @JvmName("jruahnouwijbtemg")
    public suspend fun loadBalancingSettings(`value`: Output<LoadBalancingSettingsParametersArgs>) {
        this.loadBalancingSettings = value
    }

    /**
     * @param value Name of the origin group which is unique within the endpoint.
     */
    @JvmName("gaecnwsvqsjodygr")
    public suspend fun originGroupName(`value`: Output<String>) {
        this.originGroupName = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("qqxdhvqyqshsceuh")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ujshlprvemrauuqg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("eflpejtmwmdhskbb")
    public suspend fun sessionAffinityState(`value`: Output<Either<String, EnabledState>>) {
        this.sessionAffinityState = value
    }

    /**
     * @param value Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    @JvmName("rhctrnmoxlvvixya")
    public suspend fun trafficRestorationTimeToHealedOrNewEndpointsInMinutes(`value`: Output<Int>) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = value
    }

    /**
     * @param value Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("ywtnobkfiyrmbpbn")
    public suspend fun healthProbeSettings(`value`: HealthProbeParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("nhukthfjhetsxrrl")
    public suspend
    fun healthProbeSettings(argument: suspend HealthProbeParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HealthProbeParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param value Load balancing settings for a backend pool
     */
    @JvmName("audgtnwumrahuhou")
    public suspend fun loadBalancingSettings(`value`: LoadBalancingSettingsParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings for a backend pool
     */
    @JvmName("chnjhviyvjihabos")
    public suspend
    fun loadBalancingSettings(argument: suspend LoadBalancingSettingsParametersArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancingSettingsParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param value Name of the origin group which is unique within the endpoint.
     */
    @JvmName("ynpmtrkbtdxeabtx")
    public suspend fun originGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroupName = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("urdrinjuqjlheemd")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cvobuwtuskkndifn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("wdtwjtcmsjieeosr")
    public suspend fun sessionAffinityState(`value`: Either<String, EnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAffinityState = mapped
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("ewqhdibrqedhkdvg")
    public fun sessionAffinityState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAffinityState = mapped
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("isklxsamsokajvyd")
    public fun sessionAffinityState(`value`: EnabledState) {
        val toBeMapped = Either.ofRight<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAffinityState = mapped
    }

    /**
     * @param value Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    @JvmName("tmndunctlaxijrxb")
    public suspend fun trafficRestorationTimeToHealedOrNewEndpointsInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = mapped
    }

    internal fun build(): AFDOriginGroupArgs = AFDOriginGroupArgs(
        healthProbeSettings = healthProbeSettings,
        loadBalancingSettings = loadBalancingSettings,
        originGroupName = originGroupName,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        sessionAffinityState = sessionAffinityState,
        trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes,
    )
}
