@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.KeyGroupArgs.builder
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contains a list of references of UrlSigningKey type secret objects.
 * Azure REST API version: 2023-07-01-preview.
 * ## Example Usage
 * ### KeyGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var keyGroup = new AzureNative.Cdn.KeyGroup("keyGroup", new()
 *     {
 *         KeyGroupName = "kg1",
 *         KeyReferences = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret1",
 *             },
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret2",
 *             },
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret3",
 *             },
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewKeyGroup(ctx, "keyGroup", &cdn.KeyGroupArgs{
 * 			KeyGroupName: pulumi.String("kg1"),
 * 			KeyReferences: []cdn.ResourceReferenceArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret1"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret2"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret3"),
 * 				},
 * 			},
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.KeyGroup;
 * import com.pulumi.azurenative.cdn.KeyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var keyGroup = new KeyGroup("keyGroup", KeyGroupArgs.builder()
 *             .keyGroupName("kg1")
 *             .keyReferences(
 *                 Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret1"),
 *                 Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret2"),
 *                 Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/secrets/secret3"))
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:KeyGroup kg1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/keyGroups/{keyGroupName}
 * ```
 * @property keyGroupName Name of the KeyGroup under the profile.
 * @property keyReferences Names of UrlSigningKey type secret objects
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class KeyGroupArgs(
    public val keyGroupName: Output<String>? = null,
    public val keyReferences: Output<List<ResourceReferenceArgs>>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.KeyGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.KeyGroupArgs =
        com.pulumi.azurenative.cdn.KeyGroupArgs.builder()
            .keyGroupName(keyGroupName?.applyValue({ args0 -> args0 }))
            .keyReferences(
                keyReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyGroupArgs].
 */
@PulumiTagMarker
public class KeyGroupArgsBuilder internal constructor() {
    private var keyGroupName: Output<String>? = null

    private var keyReferences: Output<List<ResourceReferenceArgs>>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the KeyGroup under the profile.
     */
    @JvmName("jpptlvyikfnmiaec")
    public suspend fun keyGroupName(`value`: Output<String>) {
        this.keyGroupName = value
    }

    /**
     * @param value Names of UrlSigningKey type secret objects
     */
    @JvmName("bmmlulyvkmmeuxdk")
    public suspend fun keyReferences(`value`: Output<List<ResourceReferenceArgs>>) {
        this.keyReferences = value
    }

    @JvmName("yyqfanrjjefxicbt")
    public suspend fun keyReferences(vararg values: Output<ResourceReferenceArgs>) {
        this.keyReferences = Output.all(values.asList())
    }

    /**
     * @param values Names of UrlSigningKey type secret objects
     */
    @JvmName("jkmyfvjgmgnnvowu")
    public suspend fun keyReferences(values: List<Output<ResourceReferenceArgs>>) {
        this.keyReferences = Output.all(values)
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.
     */
    @JvmName("qaniipijtocplivq")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("gcknfkrpkxlthksb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the KeyGroup under the profile.
     */
    @JvmName("luoyexahvmnictin")
    public suspend fun keyGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyGroupName = mapped
    }

    /**
     * @param value Names of UrlSigningKey type secret objects
     */
    @JvmName("ugqqlhfumdoacudy")
    public suspend fun keyReferences(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyReferences = mapped
    }

    /**
     * @param argument Names of UrlSigningKey type secret objects
     */
    @JvmName("iljsuifackpnesgm")
    public suspend
    fun keyReferences(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyReferences = mapped
    }

    /**
     * @param argument Names of UrlSigningKey type secret objects
     */
    @JvmName("rlpibmajjgirbval")
    public suspend fun keyReferences(
        vararg
        argument: suspend ResourceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyReferences = mapped
    }

    /**
     * @param argument Names of UrlSigningKey type secret objects
     */
    @JvmName("wvaduitfydwsihcd")
    public suspend fun keyReferences(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.keyReferences = mapped
    }

    /**
     * @param values Names of UrlSigningKey type secret objects
     */
    @JvmName("ycrhtkktnjhhysal")
    public suspend fun keyReferences(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyReferences = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the resource group.
     */
    @JvmName("yfjupxjqtmfdroct")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("fchusutqchdxccbq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): KeyGroupArgs = KeyGroupArgs(
        keyGroupName = keyGroupName,
        keyReferences = keyReferences,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
    )
}
