@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.CdnEndpointResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.CustomRuleListResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.ManagedRuleSetListResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.PolicySettingsResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.RateLimitRuleListResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cdn.kotlin.outputs.CdnEndpointResponse.Companion.toKotlin as cdnEndpointResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.CustomRuleListResponse.Companion.toKotlin as customRuleListResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.ManagedRuleSetListResponse.Companion.toKotlin as managedRuleSetListResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.PolicySettingsResponse.Companion.toKotlin as policySettingsResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.RateLimitRuleListResponse.Companion.toKotlin as rateLimitRuleListResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.azurenative.cdn.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Defines web application firewall policy for Azure CDN.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### Creates specific policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.Cdn.Policy("policy", new()
 *     {
 *         CustomRules = new AzureNative.Cdn.Inputs.CustomRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.CustomRuleArgs
 *                 {
 *                     Action = "Block",
 *                     EnabledState = "Enabled",
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "CH",
 *                             },
 *                             MatchVariable = "RemoteAddr",
 *                             NegateCondition = false,
 *                             Operator = "GeoMatch",
 *                             Transforms = new() { },
 *                         },
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "windows",
 *                             },
 *                             MatchVariable = "RequestHeader",
 *                             NegateCondition = false,
 *                             Operator = "Contains",
 *                             Selector = "UserAgent",
 *                             Transforms = new() { },
 *                         },
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "<?php",
 *                                 "?>",
 *                             },
 *                             MatchVariable = "QueryString",
 *                             NegateCondition = false,
 *                             Operator = "Contains",
 *                             Selector = "search",
 *                             Transforms = new[]
 *                             {
 *                                 "UrlDecode",
 *                                 "Lowercase",
 *                             },
 *                         },
 *                     },
 *                     Name = "CustomRule1",
 *                     Priority = 2,
 *                 },
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Cdn.Inputs.ManagedRuleSetListArgs
 *         {
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "Group1",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Cdn.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "Redirect",
 *                                     EnabledState = "Enabled",
 *                                     RuleId = "GROUP1-0001",
 *                                 },
 *                                 new AzureNative.Cdn.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     EnabledState = "Disabled",
 *                                     RuleId = "GROUP1-0002",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "DefaultRuleSet",
 *                     RuleSetVersion = "preview-1.0",
 *                 },
 *             },
 *         },
 *         PolicyName = "MicrosoftCdnWafPolicy",
 *         PolicySettings = new AzureNative.Cdn.Inputs.PolicySettingsArgs
 *         {
 *             DefaultCustomBlockResponseBody = "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
 *             DefaultCustomBlockResponseStatusCode = 200,
 *             DefaultRedirectUrl = "http://www.bing.com",
 *         },
 *         RateLimitRules = new AzureNative.Cdn.Inputs.RateLimitRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.RateLimitRuleArgs
 *                 {
 *                     Action = "Block",
 *                     EnabledState = "Enabled",
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24",
 *                             },
 *                             MatchVariable = "RemoteAddr",
 *                             NegateCondition = false,
 *                             Operator = "IPMatch",
 *                             Transforms = new() { },
 *                         },
 *                     },
 *                     Name = "RateLimitRule1",
 *                     Priority = 1,
 *                     RateLimitDurationInMinutes = 0,
 *                     RateLimitThreshold = 1000,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Cdn.Inputs.SkuArgs
 *         {
 *             Name = "Standard_Microsoft",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := cdn.NewPolicy(ctx, "policy", &cdn.PolicyArgs{
 * CustomRules: cdn.CustomRuleListResponse{
 * Rules: cdn.CustomRuleArray{
 * interface{}{
 * Action: pulumi.String("Block"),
 * EnabledState: pulumi.String("Enabled"),
 * MatchConditions: cdn.MatchConditionArray{
 * &cdn.MatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("CH"),
 * },
 * MatchVariable: pulumi.String("RemoteAddr"),
 * NegateCondition: pulumi.Bool(false),
 * Operator: pulumi.String("GeoMatch"),
 * Transforms: pulumi.StringArray{
 * },
 * },
 * &cdn.MatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("windows"),
 * },
 * MatchVariable: pulumi.String("RequestHeader"),
 * NegateCondition: pulumi.Bool(false),
 * Operator: pulumi.String("Contains"),
 * Selector: pulumi.String("UserAgent"),
 * Transforms: pulumi.StringArray{
 * },
 * },
 * &cdn.MatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("<?php"),
 * pulumi.String("?>"),
 * },
 * MatchVariable: pulumi.String("QueryString"),
 * NegateCondition: pulumi.Bool(false),
 * Operator: pulumi.String("Contains"),
 * Selector: pulumi.String("search"),
 * Transforms: pulumi.StringArray{
 * pulumi.String("UrlDecode"),
 * pulumi.String("Lowercase"),
 * },
 * },
 * },
 * Name: pulumi.String("CustomRule1"),
 * Priority: pulumi.Int(2),
 * },
 * },
 * },
 * Location: pulumi.String("WestUs"),
 * ManagedRules: cdn.ManagedRuleSetListResponse{
 * ManagedRuleSets: cdn.ManagedRuleSetArray{
 * interface{}{
 * RuleGroupOverrides: cdn.ManagedRuleGroupOverrideArray{
 * interface{}{
 * RuleGroupName: pulumi.String("Group1"),
 * Rules: cdn.ManagedRuleOverrideArray{
 * &cdn.ManagedRuleOverrideArgs{
 * Action: pulumi.String("Redirect"),
 * EnabledState: pulumi.String("Enabled"),
 * RuleId: pulumi.String("GROUP1-0001"),
 * },
 * &cdn.ManagedRuleOverrideArgs{
 * EnabledState: pulumi.String("Disabled"),
 * RuleId: pulumi.String("GROUP1-0002"),
 * },
 * },
 * },
 * },
 * RuleSetType: pulumi.String("DefaultRuleSet"),
 * RuleSetVersion: pulumi.String("preview-1.0"),
 * },
 * },
 * },
 * PolicyName: pulumi.String("MicrosoftCdnWafPolicy"),
 * PolicySettings: &cdn.PolicySettingsArgs{
 * DefaultCustomBlockResponseBody: pulumi.String("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 * DefaultCustomBlockResponseStatusCode: pulumi.Int(200),
 * DefaultRedirectUrl: pulumi.String("http://www.bing.com"),
 * },
 * RateLimitRules: cdn.RateLimitRuleListResponse{
 * Rules: cdn.RateLimitRuleArray{
 * interface{}{
 * Action: pulumi.String("Block"),
 * EnabledState: pulumi.String("Enabled"),
 * MatchConditions: cdn.MatchConditionArray{
 * &cdn.MatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariable: pulumi.String("RemoteAddr"),
 * NegateCondition: pulumi.Bool(false),
 * Operator: pulumi.String("IPMatch"),
 * Transforms: pulumi.StringArray{
 * },
 * },
 * },
 * Name: pulumi.String("RateLimitRule1"),
 * Priority: pulumi.Int(1),
 * RateLimitDurationInMinutes: pulumi.Int(0),
 * RateLimitThreshold: pulumi.Int(1000),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &cdn.SkuArgs{
 * Name: pulumi.String("Standard_Microsoft"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Policy;
 * import com.pulumi.azurenative.cdn.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .customRules(Map.of("rules", Map.ofEntries(
 *                 Map.entry("action", "Block"),
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("matchConditions",
 *                     Map.ofEntries(
 *                         Map.entry("matchValue", "CH"),
 *                         Map.entry("matchVariable", "RemoteAddr"),
 *                         Map.entry("negateCondition", false),
 *                         Map.entry("operator", "GeoMatch"),
 *                         Map.entry("transforms", )
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchValue", "windows"),
 *                         Map.entry("matchVariable", "RequestHeader"),
 *                         Map.entry("negateCondition", false),
 *                         Map.entry("operator", "Contains"),
 *                         Map.entry("selector", "UserAgent"),
 *                         Map.entry("transforms", )
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchValue",
 *                             "<?php",
 *                             "?>"),
 *                         Map.entry("matchVariable", "QueryString"),
 *                         Map.entry("negateCondition", false),
 *                         Map.entry("operator", "Contains"),
 *                         Map.entry("selector", "search"),
 *                         Map.entry("transforms",
 *                             "UrlDecode",
 *                             "Lowercase")
 *                     )),
 *                 Map.entry("name", "CustomRule1"),
 *                 Map.entry("priority", 2)
 *             )))
 *             .location("WestUs")
 *             .managedRules(Map.of("managedRuleSets", Map.ofEntries(
 *                 Map.entry("ruleGroupOverrides", Map.ofEntries(
 *                     Map.entry("ruleGroupName", "Group1"),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("action", "Redirect"),
 *                             Map.entry("enabledState", "Enabled"),
 *                             Map.entry("ruleId", "GROUP1-0001")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("enabledState", "Disabled"),
 *                             Map.entry("ruleId", "GROUP1-0002")
 *                         ))
 *                 )),
 *                 Map.entry("ruleSetType", "DefaultRuleSet"),
 *                 Map.entry("ruleSetVersion", "preview-1.0")
 *             )))
 *             .policyName("MicrosoftCdnWafPolicy")
 *             .policySettings(Map.ofEntries(
 *                 Map.entry("defaultCustomBlockResponseBody", "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 *                 Map.entry("defaultCustomBlockResponseStatusCode", 200),
 *                 Map.entry("defaultRedirectUrl", "http://www.bing.com")
 *             ))
 *             .rateLimitRules(Map.of("rules", Map.ofEntries(
 *                 Map.entry("action", "Block"),
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("matchConditions", Map.ofEntries(
 *                     Map.entry("matchValue",
 *                         "192.168.1.0/24",
 *                         "10.0.0.0/24"),
 *                     Map.entry("matchVariable", "RemoteAddr"),
 *                     Map.entry("negateCondition", false),
 *                     Map.entry("operator", "IPMatch"),
 *                     Map.entry("transforms", )
 *                 )),
 *                 Map.entry("name", "RateLimitRule1"),
 *                 Map.entry("priority", 1),
 *                 Map.entry("rateLimitDurationInMinutes", 0),
 *                 Map.entry("rateLimitThreshold", 1000)
 *             )))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard_Microsoft"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Policy MicrosoftCdnWafPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/cdnWebApplicationFirewallPolicies/{policyName}
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Describes custom rules inside the policy.
     */
    public val customRules: Output<CustomRuleListResponse>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customRuleListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes Azure CDN endpoints associated with this Web Application Firewall policy.
     */
    public val endpointLinks: Output<List<CdnEndpointResponse>>
        get() = javaResource.endpointLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cdnEndpointResponseToKotlin(args0) })
            })
        })

    /**
     * Gets a unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    public val extendedProperties: Output<Map<String, String>>?
        get() = javaResource.extendedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Describes managed rules inside the policy.
     */
    public val managedRules: Output<ManagedRuleSetListResponse>?
        get() = javaResource.managedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRuleSetListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes  policySettings for policy
     */
    public val policySettings: Output<PolicySettingsResponse>?
        get() = javaResource.policySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the WebApplicationFirewallPolicy.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Describes rate limit rules inside the policy.
     */
    public val rateLimitRules: Output<RateLimitRuleListResponse>?
        get() = javaResource.rateLimitRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> rateLimitRuleListResponseToKotlin(args0) })
            }).orElse(null)
        })

    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.azurenative.cdn.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
