@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.RuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Friendly RuleSet name mapping to the any RuleSet or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### RuleSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ruleSet = new AzureNative.Cdn.RuleSet("ruleSet", new()
 *     {
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         RuleSetName = "ruleSet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewRuleSet(ctx, "ruleSet", &cdn.RuleSetArgs{
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			RuleSetName:       pulumi.String("ruleSet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.RuleSet;
 * import com.pulumi.azurenative.cdn.RuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ruleSet = new RuleSet("ruleSet", RuleSetArgs.builder()
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .ruleSetName("ruleSet1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:RuleSet ruleSet1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}
 * ```
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property ruleSetName Name of the rule set under the profile which is unique globally
 */
public data class RuleSetArgs(
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.RuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.RuleSetArgs =
        com.pulumi.azurenative.cdn.RuleSetArgs.builder()
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleSetArgs].
 */
@PulumiTagMarker
public class RuleSetArgsBuilder internal constructor() {
    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleSetName: Output<String>? = null

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("ixxltnbyaoskpmok")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("pldaaqgccydeivfn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the rule set under the profile which is unique globally
     */
    @JvmName("ubebqexdpkdcqaxy")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("yshwvjsoqjvobors")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("kgwtimpddybkqyqr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the rule set under the profile which is unique globally
     */
    @JvmName("iarrrtwsfsikjcvv")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): RuleSetArgs = RuleSetArgs(
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        ruleSetName = ruleSetName,
    )
}
