@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.SecurityPolicyWebApplicationFirewallParametersResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cdn.kotlin.outputs.SecurityPolicyWebApplicationFirewallParametersResponse.Companion.toKotlin as securityPolicyWebApplicationFirewallParametersResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SecurityPolicy].
 */
@PulumiTagMarker
public class SecurityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityPolicyArgs = SecurityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityPolicyArgsBuilder.() -> Unit) {
        val builder = SecurityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityPolicy {
        val builtJavaResource = com.pulumi.azurenative.cdn.SecurityPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityPolicy(builtJavaResource)
    }
}

/**
 * SecurityPolicy association for AzureFrontDoor profile
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### SecurityPolicies_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityPolicy = new AzureNative.Cdn.SecurityPolicy("securityPolicy", new()
 *     {
 *         Parameters = new AzureNative.Cdn.Inputs.SecurityPolicyWebApplicationFirewallParametersArgs
 *         {
 *             Associations = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.SecurityPolicyWebApplicationFirewallAssociationArgs
 *                 {
 *                     Domains = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.ActivatedResourceReferenceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain1",
 *                         },
 *                         new AzureNative.Cdn.Inputs.ActivatedResourceReferenceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain2",
 *                         },
 *                     },
 *                     PatternsToMatch = new[]
 *                     {
 *                         "/*",
 *                     },
 *                 },
 *             },
 *             Type = "WebApplicationFirewall",
 *             WafPolicy = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Network/frontdoorwebapplicationfirewallpolicies/wafTest",
 *             },
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         SecurityPolicyName = "securityPolicy1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := cdn.NewSecurityPolicy(ctx, "securityPolicy", &cdn.SecurityPolicyArgs{
 * Parameters: interface{}{
 * Associations: cdn.SecurityPolicyWebApplicationFirewallAssociationArray{
 * interface{}{
 * Domains: cdn.ActivatedResourceReferenceArray{
 * &cdn.ActivatedResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain1"),
 * },
 * &cdn.ActivatedResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain2"),
 * },
 * },
 * PatternsToMatch: pulumi.StringArray{
 * pulumi.String("/*"),
 * },
 * },
 * },
 * Type: pulumi.String("WebApplicationFirewall"),
 * WafPolicy: &cdn.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Network/frontdoorwebapplicationfirewallpolicies/wafTest"),
 * },
 * },
 * ProfileName: pulumi.String("profile1"),
 * ResourceGroupName: pulumi.String("RG"),
 * SecurityPolicyName: pulumi.String("securityPolicy1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.SecurityPolicy;
 * import com.pulumi.azurenative.cdn.SecurityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityPolicy = new SecurityPolicy("securityPolicy", SecurityPolicyArgs.builder()
 *             .parameters(Map.ofEntries(
 *                 Map.entry("associations", Map.ofEntries(
 *                     Map.entry("domains",
 *                         Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain1"),
 *                         Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain2")),
 *                     Map.entry("patternsToMatch", "/*")
 *                 )),
 *                 Map.entry("type", "WebApplicationFirewall"),
 *                 Map.entry("wafPolicy", Map.of("id", "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Network/frontdoorwebapplicationfirewallpolicies/wafTest"))
 *             ))
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .securityPolicyName("securityPolicy1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:SecurityPolicy securityPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}
 * ```
 * */*/*/
 */
public class SecurityPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.SecurityPolicy,
) : KotlinCustomResource(javaResource, SecurityPolicyMapper) {
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * object which contains security policy parameters
     */
    public val parameters: Output<SecurityPolicyWebApplicationFirewallParametersResponse>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityPolicyWebApplicationFirewallParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the profile which holds the security policy.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityPolicyMapper : ResourceMapper<SecurityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.SecurityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SecurityPolicy = SecurityPolicy(
        javaResource as
            com.pulumi.azurenative.cdn.SecurityPolicy,
    )
}

/**
 * @see [SecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityPolicy].
 */
public suspend fun securityPolicy(
    name: String,
    block: suspend SecurityPolicyResourceBuilder.() -> Unit,
): SecurityPolicy {
    val builder = SecurityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityPolicy(name: String): SecurityPolicy {
    val builder = SecurityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
