@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes operator to be matched
 */
public enum class Operator(
    public val javaValue: com.pulumi.azurenative.cdn.enums.Operator,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.Operator> {
    Any(com.pulumi.azurenative.cdn.enums.Operator.Any),
    IPMatch(com.pulumi.azurenative.cdn.enums.Operator.IPMatch),
    GeoMatch(com.pulumi.azurenative.cdn.enums.Operator.GeoMatch),
    Equal(com.pulumi.azurenative.cdn.enums.Operator.Equal),
    Contains(com.pulumi.azurenative.cdn.enums.Operator.Contains),
    LessThan(com.pulumi.azurenative.cdn.enums.Operator.LessThan),
    GreaterThan(com.pulumi.azurenative.cdn.enums.Operator.GreaterThan),
    LessThanOrEqual(com.pulumi.azurenative.cdn.enums.Operator.LessThanOrEqual),
    GreaterThanOrEqual(com.pulumi.azurenative.cdn.enums.Operator.GreaterThanOrEqual),
    BeginsWith(com.pulumi.azurenative.cdn.enums.Operator.BeginsWith),
    EndsWith(com.pulumi.azurenative.cdn.enums.Operator.EndsWith),
    RegEx(com.pulumi.azurenative.cdn.enums.Operator.RegEx),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.Operator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.Operator): Operator =
            Operator.values().first { it.javaValue == javaType }
    }
}
