@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
 */
public enum class RuleIsCompressionEnabled(
    public val javaValue: com.pulumi.azurenative.cdn.enums.RuleIsCompressionEnabled,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.RuleIsCompressionEnabled> {
    Enabled(com.pulumi.azurenative.cdn.enums.RuleIsCompressionEnabled.Enabled),
    Disabled(com.pulumi.azurenative.cdn.enums.RuleIsCompressionEnabled.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.RuleIsCompressionEnabled = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.RuleIsCompressionEnabled):
            RuleIsCompressionEnabled =
            RuleIsCompressionEnabled.values().first { it.javaValue == javaType }
    }
}
