@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The main origin of CDN content which is added when creating a CDN endpoint.
 * @property enabled Origin is enabled for load balancing or not. By default, origin is always enabled.
 * @property hostName The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint.
 * @property httpPort The value of the HTTP port. Must be between 1 and 65535.
 * @property httpsPort The value of the HTTPS port. Must be between 1 and 65535.
 * @property name Origin name which must be unique within the endpoint.
 * @property originHostHeader The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
 * @property priority Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
 * @property privateLinkAlias The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
 * @property privateLinkApprovalMessage A custom message to be included in the approval request to connect to the Private Link.
 * @property privateLinkLocation The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
 * @property privateLinkResourceId The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property weight Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
 */
public data class DeepCreatedOriginArgs(
    public val enabled: Output<Boolean>? = null,
    public val hostName: Output<String>,
    public val httpPort: Output<Int>? = null,
    public val httpsPort: Output<Int>? = null,
    public val name: Output<String>,
    public val originHostHeader: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val privateLinkAlias: Output<String>? = null,
    public val privateLinkApprovalMessage: Output<String>? = null,
    public val privateLinkLocation: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginArgs =
        com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .hostName(hostName.applyValue({ args0 -> args0 }))
            .httpPort(httpPort?.applyValue({ args0 -> args0 }))
            .httpsPort(httpsPort?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .originHostHeader(originHostHeader?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .privateLinkAlias(privateLinkAlias?.applyValue({ args0 -> args0 }))
            .privateLinkApprovalMessage(privateLinkApprovalMessage?.applyValue({ args0 -> args0 }))
            .privateLinkLocation(privateLinkLocation?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeepCreatedOriginArgs].
 */
@PulumiTagMarker
public class DeepCreatedOriginArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var httpPort: Output<Int>? = null

    private var httpsPort: Output<Int>? = null

    private var name: Output<String>? = null

    private var originHostHeader: Output<String>? = null

    private var priority: Output<Int>? = null

    private var privateLinkAlias: Output<String>? = null

    private var privateLinkApprovalMessage: Output<String>? = null

    private var privateLinkLocation: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Origin is enabled for load balancing or not. By default, origin is always enabled.
     */
    @JvmName("xvcrtnwlbwtbfrsf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint.
     */
    @JvmName("yjvduqfgirxwhrbc")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The value of the HTTP port. Must be between 1 and 65535.
     */
    @JvmName("ltejfkygaejqlfml")
    public suspend fun httpPort(`value`: Output<Int>) {
        this.httpPort = value
    }

    /**
     * @param value The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JvmName("cbelhtpfjqkrjwbc")
    public suspend fun httpsPort(`value`: Output<Int>) {
        this.httpsPort = value
    }

    /**
     * @param value Origin name which must be unique within the endpoint.
     */
    @JvmName("adwkdkpqskeikomi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     */
    @JvmName("llftuxclljvaloit")
    public suspend fun originHostHeader(`value`: Output<String>) {
        this.originHostHeader = value
    }

    /**
     * @param value Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
     */
    @JvmName("qhmpooyoojonomdv")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
     */
    @JvmName("gkxfjlijnrtaavug")
    public suspend fun privateLinkAlias(`value`: Output<String>) {
        this.privateLinkAlias = value
    }

    /**
     * @param value A custom message to be included in the approval request to connect to the Private Link.
     */
    @JvmName("cystwreprdbuujoj")
    public suspend fun privateLinkApprovalMessage(`value`: Output<String>) {
        this.privateLinkApprovalMessage = value
    }

    /**
     * @param value The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    @JvmName("svxdywptjjpfxgfv")
    public suspend fun privateLinkLocation(`value`: Output<String>) {
        this.privateLinkLocation = value
    }

    /**
     * @param value The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("ilscmecvfpdercsp")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    @JvmName("qlloyaffmuctwvas")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Origin is enabled for load balancing or not. By default, origin is always enabled.
     */
    @JvmName("yjkuxiwghknooxcu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint.
     */
    @JvmName("ylbxdyhwfojvexuc")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The value of the HTTP port. Must be between 1 and 65535.
     */
    @JvmName("ewwbvnephqrpabxr")
    public suspend fun httpPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPort = mapped
    }

    /**
     * @param value The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JvmName("gliebbicgeoedlts")
    public suspend fun httpsPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPort = mapped
    }

    /**
     * @param value Origin name which must be unique within the endpoint.
     */
    @JvmName("wgvoeuuuwadvroig")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     */
    @JvmName("pfdfohkicatukeae")
    public suspend fun originHostHeader(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originHostHeader = mapped
    }

    /**
     * @param value Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
     */
    @JvmName("kowbvtcnebrcjguf")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
     */
    @JvmName("sghigvtmepueedpp")
    public suspend fun privateLinkAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkAlias = mapped
    }

    /**
     * @param value A custom message to be included in the approval request to connect to the Private Link.
     */
    @JvmName("chbhqwdjahwovwqr")
    public suspend fun privateLinkApprovalMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkApprovalMessage = mapped
    }

    /**
     * @param value The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    @JvmName("mlwbuybvnscxbdnv")
    public suspend fun privateLinkLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkLocation = mapped
    }

    /**
     * @param value The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("ufwpchygtwuosvin")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    @JvmName("hyrjflyqoefsxpip")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): DeepCreatedOriginArgs = DeepCreatedOriginArgs(
        enabled = enabled,
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        httpPort = httpPort,
        httpsPort = httpsPort,
        name = name ?: throw PulumiNullFieldException("name"),
        originHostHeader = originHostHeader,
        priority = priority,
        privateLinkAlias = privateLinkAlias,
        privateLinkApprovalMessage = privateLinkApprovalMessage,
        privateLinkLocation = privateLinkLocation,
        privateLinkResourceId = privateLinkResourceId,
        weight = weight,
    )
}
