@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleClientPortConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the ClientPort condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'ClientPort'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleClientPortConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<ClientPortMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleClientPortConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleClientPortConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleClientPortConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleClientPortConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleClientPortConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<ClientPortMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'ClientPort'.
     */
    @JvmName("tkbcfojrennmamsa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("jwrucpilcmdmnugv")
    public suspend fun parameters(`value`: Output<ClientPortMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'ClientPort'.
     */
    @JvmName("ivnuweqltchnyrxq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("uyayqhnkkjggnvsk")
    public suspend fun parameters(`value`: ClientPortMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("yaerbiqyfmkxwyjf")
    public suspend
    fun parameters(argument: suspend ClientPortMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ClientPortMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleClientPortConditionArgs = DeliveryRuleClientPortConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
