@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleHostNameConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the HostName condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'HostName'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleHostNameConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<HostNameMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleHostNameConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleHostNameConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleHostNameConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleHostNameConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleHostNameConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<HostNameMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'HostName'.
     */
    @JvmName("mrdsghpwpbicfysm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("cqcvlrqffbhjlhus")
    public suspend fun parameters(`value`: Output<HostNameMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'HostName'.
     */
    @JvmName("ahqhueplqpbbtxsf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("bveymqjubqmimofb")
    public suspend fun parameters(`value`: HostNameMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("hwdosmmlmutetuus")
    public suspend
    fun parameters(argument: suspend HostNameMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HostNameMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleHostNameConditionArgs = DeliveryRuleHostNameConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
