@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleHttpVersionConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the HttpVersion condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'HttpVersion'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleHttpVersionConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<HttpVersionMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleHttpVersionConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleHttpVersionConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleHttpVersionConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleHttpVersionConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleHttpVersionConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<HttpVersionMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'HttpVersion'.
     */
    @JvmName("vsreqfmafunbhsgv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("tggopoeoyfymustc")
    public suspend fun parameters(`value`: Output<HttpVersionMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'HttpVersion'.
     */
    @JvmName("muwcafnilpwsxuxw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("unqtgtdekrqyhlvc")
    public suspend fun parameters(`value`: HttpVersionMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("kevdaffxqbdoaiqg")
    public suspend
    fun parameters(argument: suspend HttpVersionMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HttpVersionMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleHttpVersionConditionArgs = DeliveryRuleHttpVersionConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
