@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the request header action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'ModifyRequestHeader'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleRequestHeaderActionArgs(
    public val name: Output<String>,
    public val parameters: Output<HeaderActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderActionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRequestHeaderActionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRequestHeaderActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<HeaderActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'ModifyRequestHeader'.
     */
    @JvmName("maujkssbwjmgeerd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("wdkmdxkjxbsdrjyg")
    public suspend fun parameters(`value`: Output<HeaderActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'ModifyRequestHeader'.
     */
    @JvmName("crneryeplqilwnlj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("gyneulmfqsjpqgcq")
    public suspend fun parameters(`value`: HeaderActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("deslfbaxyvqkiejk")
    public suspend fun parameters(argument: suspend HeaderActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HeaderActionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRequestHeaderActionArgs = DeliveryRuleRequestHeaderActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
