@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the RequestHeader condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestHeader'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestHeaderConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<RequestHeaderMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestHeaderConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRequestHeaderConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRequestHeaderConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RequestHeaderMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestHeader'.
     */
    @JvmName("ihdaoclhiwhydqnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("bforbsgjlrrvxkmh")
    public suspend fun parameters(`value`: Output<RequestHeaderMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestHeader'.
     */
    @JvmName("xioytbymrnyxuwvk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("drwqccaumdbukixl")
    public suspend fun parameters(`value`: RequestHeaderMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("kgltkfnuvlfknkxp")
    public suspend
    fun parameters(argument: suspend RequestHeaderMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RequestHeaderMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRequestHeaderConditionArgs =
        DeliveryRuleRequestHeaderConditionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
