@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleResponseHeaderActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the response header action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'ModifyResponseHeader'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleResponseHeaderActionArgs(
    public val name: Output<String>,
    public val parameters: Output<HeaderActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleResponseHeaderActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleResponseHeaderActionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleResponseHeaderActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleResponseHeaderActionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleResponseHeaderActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<HeaderActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'ModifyResponseHeader'.
     */
    @JvmName("nyqxnuwexraqaiwr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("rcqrltslicdwdsqn")
    public suspend fun parameters(`value`: Output<HeaderActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'ModifyResponseHeader'.
     */
    @JvmName("sqkebnqqehphdsek")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("xyugdwmfuofavmfm")
    public suspend fun parameters(`value`: HeaderActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("fcutbqejvsnmhgbo")
    public suspend fun parameters(argument: suspend HeaderActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HeaderActionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleResponseHeaderActionArgs = DeliveryRuleResponseHeaderActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
