@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlPathConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the UrlPath condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'UrlPath'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleUrlPathConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<UrlPathMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlPathConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlPathConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleUrlPathConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleUrlPathConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleUrlPathConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<UrlPathMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'UrlPath'.
     */
    @JvmName("pgcpdaufhichiyvi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("uxhgiwmiqgvfgdrc")
    public suspend fun parameters(`value`: Output<UrlPathMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'UrlPath'.
     */
    @JvmName("fdswkjkkoonjbrpo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("hupdtgfdnynafgjk")
    public suspend fun parameters(`value`: UrlPathMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("nwtsueaqphlaobbc")
    public suspend
    fun parameters(argument: suspend UrlPathMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = UrlPathMatchConditionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleUrlPathConditionArgs = DeliveryRuleUrlPathConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
