@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetCustomDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customDomainName Name of the custom domain within an endpoint.
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetCustomDomainPlainArgs(
    public val customDomainName: String,
    public val endpointName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetCustomDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetCustomDomainPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetCustomDomainPlainArgs.builder()
            .customDomainName(customDomainName.let({ args0 -> args0 }))
            .endpointName(endpointName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomDomainPlainArgs].
 */
@PulumiTagMarker
public class GetCustomDomainPlainArgsBuilder internal constructor() {
    private var customDomainName: String? = null

    private var endpointName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the custom domain within an endpoint.
     */
    @JvmName("brmwdlqwehuoagfo")
    public suspend fun customDomainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customDomainName = mapped
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("qyfpmeijlokfrbmh")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("whvyupecohdhbnbu")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("hiqodvbhspfrmdph")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCustomDomainPlainArgs = GetCustomDomainPlainArgs(
        customDomainName = customDomainName ?: throw PulumiNullFieldException("customDomainName"),
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
