@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetEndpointPlainArgs(
    public val endpointName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetEndpointPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetEndpointPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("uywvodfifikhvmgd")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("iuetubdyfupxqbks")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("bhukxftwsrbwuylk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
