@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.HealthProbeRequestType
import com.pulumi.azurenative.cdn.kotlin.enums.ProbeProtocol
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The JSON object that contains the properties to send health probes to origin.
 * @property probeIntervalInSeconds The number of seconds between health probes.Default is 240sec.
 * @property probePath The path relative to the origin that is used to determine the health of the origin.
 * @property probeProtocol Protocol to use for health probe.
 * @property probeRequestType The type of health probe request that is made.
 */
public data class HealthProbeParametersArgs(
    public val probeIntervalInSeconds: Output<Int>? = null,
    public val probePath: Output<String>? = null,
    public val probeProtocol: Output<ProbeProtocol>? = null,
    public val probeRequestType: Output<HealthProbeRequestType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs =
        com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs.builder()
            .probeIntervalInSeconds(probeIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .probePath(probePath?.applyValue({ args0 -> args0 }))
            .probeProtocol(probeProtocol?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .probeRequestType(
                probeRequestType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HealthProbeParametersArgs].
 */
@PulumiTagMarker
public class HealthProbeParametersArgsBuilder internal constructor() {
    private var probeIntervalInSeconds: Output<Int>? = null

    private var probePath: Output<String>? = null

    private var probeProtocol: Output<ProbeProtocol>? = null

    private var probeRequestType: Output<HealthProbeRequestType>? = null

    /**
     * @param value The number of seconds between health probes.Default is 240sec.
     */
    @JvmName("pqfouttxdllalitg")
    public suspend fun probeIntervalInSeconds(`value`: Output<Int>) {
        this.probeIntervalInSeconds = value
    }

    /**
     * @param value The path relative to the origin that is used to determine the health of the origin.
     */
    @JvmName("ryplxetdeptthjef")
    public suspend fun probePath(`value`: Output<String>) {
        this.probePath = value
    }

    /**
     * @param value Protocol to use for health probe.
     */
    @JvmName("dwigtevhxwnuegac")
    public suspend fun probeProtocol(`value`: Output<ProbeProtocol>) {
        this.probeProtocol = value
    }

    /**
     * @param value The type of health probe request that is made.
     */
    @JvmName("roixpmrycywgxrse")
    public suspend fun probeRequestType(`value`: Output<HealthProbeRequestType>) {
        this.probeRequestType = value
    }

    /**
     * @param value The number of seconds between health probes.Default is 240sec.
     */
    @JvmName("wugimfwgsioxabis")
    public suspend fun probeIntervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeIntervalInSeconds = mapped
    }

    /**
     * @param value The path relative to the origin that is used to determine the health of the origin.
     */
    @JvmName("pkhbdttlvnymtyqt")
    public suspend fun probePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probePath = mapped
    }

    /**
     * @param value Protocol to use for health probe.
     */
    @JvmName("hgaxtnyebwspqeeh")
    public suspend fun probeProtocol(`value`: ProbeProtocol?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeProtocol = mapped
    }

    /**
     * @param value The type of health probe request that is made.
     */
    @JvmName("eeaotomtmgmbifck")
    public suspend fun probeRequestType(`value`: HealthProbeRequestType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeRequestType = mapped
    }

    internal fun build(): HealthProbeParametersArgs = HealthProbeParametersArgs(
        probeIntervalInSeconds = probeIntervalInSeconds,
        probePath = probePath,
        probeProtocol = probeProtocol,
        probeRequestType = probeRequestType,
    )
}
