@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.MatchConditionArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.Operator
import com.pulumi.azurenative.cdn.kotlin.enums.TransformType
import com.pulumi.azurenative.cdn.kotlin.enums.WafMatchVariable
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Define match conditions
 * @property matchValue List of possible match values.
 * @property matchVariable Match variable to compare against.
 * @property negateCondition Describes if the result of this condition should be negated.
 * @property operator Describes operator to be matched
 * @property selector Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
 * @property transforms List of transforms.
 */
public data class MatchConditionArgs(
    public val matchValue: Output<List<String>>,
    public val matchVariable: Output<Either<String, WafMatchVariable>>,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, Operator>>,
    public val selector: Output<String>? = null,
    public val transforms: Output<List<Either<String, TransformType>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.MatchConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.MatchConditionArgs =
        com.pulumi.azurenative.cdn.inputs.MatchConditionArgs.builder()
            .matchValue(matchValue.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchVariable(
                matchVariable.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [MatchConditionArgs].
 */
@PulumiTagMarker
public class MatchConditionArgsBuilder internal constructor() {
    private var matchValue: Output<List<String>>? = null

    private var matchVariable: Output<Either<String, WafMatchVariable>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var selector: Output<String>? = null

    private var transforms: Output<List<Either<String, TransformType>>>? = null

    /**
     * @param value List of possible match values.
     */
    @JvmName("pegctghqmpthrcnh")
    public suspend fun matchValue(`value`: Output<List<String>>) {
        this.matchValue = value
    }

    @JvmName("svfpqresofluupvh")
    public suspend fun matchValue(vararg values: Output<String>) {
        this.matchValue = Output.all(values.asList())
    }

    /**
     * @param values List of possible match values.
     */
    @JvmName("svortndtttdeufvr")
    public suspend fun matchValue(values: List<Output<String>>) {
        this.matchValue = Output.all(values)
    }

    /**
     * @param value Match variable to compare against.
     */
    @JvmName("qeiupekyverpmbaf")
    public suspend fun matchVariable(`value`: Output<Either<String, WafMatchVariable>>) {
        this.matchVariable = value
    }

    /**
     * @param value Describes if the result of this condition should be negated.
     */
    @JvmName("vtfrcyaujoxuwnxm")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("wctscieqohvhebcv")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
     */
    @JvmName("rgxxufyebhyhfxuv")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value List of transforms.
     */
    @JvmName("nldsnlminvtytafb")
    public suspend fun transforms(`value`: Output<List<Either<String, TransformType>>>) {
        this.transforms = value
    }

    @JvmName("yccjackwgdvyepjt")
    public suspend fun transforms(vararg values: Output<Either<String, TransformType>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms.
     */
    @JvmName("vtxbklkmjujxbrex")
    public suspend fun transforms(values: List<Output<Either<String, TransformType>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value List of possible match values.
     */
    @JvmName("lljdfhpfhtmfidmr")
    public suspend fun matchValue(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValue = mapped
    }

    /**
     * @param values List of possible match values.
     */
    @JvmName("dyktxlohtbeckkrm")
    public suspend fun matchValue(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValue = mapped
    }

    /**
     * @param value Match variable to compare against.
     */
    @JvmName("fdfgawpsqiwyahra")
    public suspend fun matchVariable(`value`: Either<String, WafMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Match variable to compare against.
     */
    @JvmName("goptwlgvafgxsyja")
    public fun matchVariable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WafMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Match variable to compare against.
     */
    @JvmName("ctkbilhvqbwvvrxd")
    public fun matchVariable(`value`: WafMatchVariable) {
        val toBeMapped = Either.ofRight<String, WafMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Describes if the result of this condition should be negated.
     */
    @JvmName("xrbjtxbhrwhhfdrf")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("iesanicviugcqjhh")
    public suspend fun `operator`(`value`: Either<String, Operator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("wwoxvdyxvfkmdcwv")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("rwksfhxjkyibaqlb")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
     */
    @JvmName("ktfmktlciepcorca")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value List of transforms.
     */
    @JvmName("cqynuuukmnfrvihd")
    public suspend fun transforms(`value`: List<Either<String, TransformType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms.
     */
    @JvmName("qvagfqikpkkrjuck")
    public suspend fun transforms(vararg values: Either<String, TransformType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    internal fun build(): MatchConditionArgs = MatchConditionArgs(
        matchValue = matchValue ?: throw PulumiNullFieldException("matchValue"),
        matchVariable = matchVariable ?: throw PulumiNullFieldException("matchVariable"),
        negateCondition = negateCondition,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        selector = selector,
        transforms = transforms,
    )
}
