@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.ForwardingProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the origin group override configuration.
 * @property forwardingProtocol Protocol this rule will use when forwarding traffic to backends.
 * @property originGroup defines the OriginGroup that would override the DefaultOriginGroup on route.
 */
public data class OriginGroupOverrideArgs(
    public val forwardingProtocol: Output<Either<String, ForwardingProtocol>>? = null,
    public val originGroup: Output<ResourceReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideArgs =
        com.pulumi.azurenative.cdn.inputs.OriginGroupOverrideArgs.builder()
            .forwardingProtocol(
                forwardingProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .originGroup(originGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OriginGroupOverrideArgs].
 */
@PulumiTagMarker
public class OriginGroupOverrideArgsBuilder internal constructor() {
    private var forwardingProtocol: Output<Either<String, ForwardingProtocol>>? = null

    private var originGroup: Output<ResourceReferenceArgs>? = null

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("tdjdvllcixapsfyy")
    public suspend fun forwardingProtocol(`value`: Output<Either<String, ForwardingProtocol>>) {
        this.forwardingProtocol = value
    }

    /**
     * @param value defines the OriginGroup that would override the DefaultOriginGroup on route.
     */
    @JvmName("tkdfpfpvlcgxcedt")
    public suspend fun originGroup(`value`: Output<ResourceReferenceArgs>) {
        this.originGroup = value
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("rcmbwvqcryrruhtx")
    public suspend fun forwardingProtocol(`value`: Either<String, ForwardingProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("mleggwmkrprbrbft")
    public fun forwardingProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ForwardingProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("asueiucclxuulygr")
    public fun forwardingProtocol(`value`: ForwardingProtocol) {
        val toBeMapped = Either.ofRight<String, ForwardingProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value defines the OriginGroup that would override the DefaultOriginGroup on route.
     */
    @JvmName("eniyfhjpqfncdqoc")
    public suspend fun originGroup(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroup = mapped
    }

    /**
     * @param argument defines the OriginGroup that would override the DefaultOriginGroup on route.
     */
    @JvmName("xncowermdsxwogtd")
    public suspend fun originGroup(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.originGroup = mapped
    }

    internal fun build(): OriginGroupOverrideArgs = OriginGroupOverrideArgs(
        forwardingProtocol = forwardingProtocol,
        originGroup = originGroup,
    )
}
