@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.PostArgsMatchConditionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.PostArgsOperator
import com.pulumi.azurenative.cdn.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for PostArgs match conditions
 * @property matchValues The match value for the condition of the delivery rule
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property selector Name of PostArg to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class PostArgsMatchConditionParametersArgs(
    public val matchValues: Output<List<String>>? = null,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, PostArgsOperator>>,
    public val selector: Output<String>? = null,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.PostArgsMatchConditionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.PostArgsMatchConditionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.PostArgsMatchConditionParametersArgs.builder()
            .matchValues(matchValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PostArgsMatchConditionParametersArgs].
 */
@PulumiTagMarker
public class PostArgsMatchConditionParametersArgsBuilder internal constructor() {
    private var matchValues: Output<List<String>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, PostArgsOperator>>? = null

    private var selector: Output<String>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("tkqcomtbcjfdwmdq")
    public suspend fun matchValues(`value`: Output<List<String>>) {
        this.matchValues = value
    }

    @JvmName("fmovdowrsdtdaahi")
    public suspend fun matchValues(vararg values: Output<String>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("onjuetbnigvnpcnn")
    public suspend fun matchValues(values: List<Output<String>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("khhymbqwxsuknyic")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("bwvgwkrlemptpnrh")
    public suspend fun `operator`(`value`: Output<Either<String, PostArgsOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value Name of PostArg to be matched
     */
    @JvmName("kxfoftpwysttbkqu")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("wbrpeyefffxtkion")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("mywltlicxrmpiuya")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("ifwrklktryccnkwt")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gtigyonoipdpaihk")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The match value for the condition of the delivery rule
     */
    @JvmName("rklbvxwdcsmfnyep")
    public suspend fun matchValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values The match value for the condition of the delivery rule
     */
    @JvmName("eeywpftfiemooycu")
    public suspend fun matchValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("upqtrjhomritetov")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("ftnyectgaknkiuab")
    public suspend fun `operator`(`value`: Either<String, PostArgsOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("whxemarvcmdykfdc")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PostArgsOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("fjndpyoywkuwctvm")
    public fun `operator`(`value`: PostArgsOperator) {
        val toBeMapped = Either.ofRight<String, PostArgsOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Name of PostArg to be matched
     */
    @JvmName("waykfgywagnnmota")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("oynnvibrtirsbkyb")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("yupprhwubbmmhrjg")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param value
     */
    @JvmName("bpildytxotvsavwb")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): PostArgsMatchConditionParametersArgs = PostArgsMatchConditionParametersArgs(
        matchValues = matchValues,
        negateCondition = negateCondition,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        selector = selector,
        transforms = transforms,
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
    )
}
