@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.RemoteAddressMatchConditionParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.RemoteAddressOperator
import com.pulumi.azurenative.cdn.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the parameters for RemoteAddress match conditions
 * @property matchValues Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class RemoteAddressMatchConditionParametersArgs(
    public val matchValues: Output<List<String>>? = null,
    public val negateCondition: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, RemoteAddressOperator>>,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.RemoteAddressMatchConditionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.RemoteAddressMatchConditionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.RemoteAddressMatchConditionParametersArgs.builder()
            .matchValues(matchValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemoteAddressMatchConditionParametersArgs].
 */
@PulumiTagMarker
public class RemoteAddressMatchConditionParametersArgsBuilder internal constructor() {
    private var matchValues: Output<List<String>>? = null

    private var negateCondition: Output<Boolean>? = null

    private var `operator`: Output<Either<String, RemoteAddressOperator>>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("bnfqrabflbqpgard")
    public suspend fun matchValues(`value`: Output<List<String>>) {
        this.matchValues = value
    }

    @JvmName("xpqidnuyxucrqiqa")
    public suspend fun matchValues(vararg values: Output<String>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("cpmthaimifsglbom")
    public suspend fun matchValues(values: List<Output<String>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("rapqhcgigsiqudou")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("lgaivmeosxoaruaa")
    public suspend fun `operator`(`value`: Output<Either<String, RemoteAddressOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("huaaaylnatyqetoh")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("dgutcvrfxuxmjjrm")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("mlbklxpqkdmgigqe")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gvrxcuppvlwybuke")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("grsmwslpidodlcbj")
    public suspend fun matchValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("ybtxfguagkyngxem")
    public suspend fun matchValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("rlvelrxyddgghunq")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("kusalijufsvpwepy")
    public suspend fun `operator`(`value`: Either<String, RemoteAddressOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("qpgscionneaenrbf")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RemoteAddressOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Describes operator to be matched
     */
    @JvmName("mxerbfgvphrouqvr")
    public fun `operator`(`value`: RemoteAddressOperator) {
        val toBeMapped = Either.ofRight<String, RemoteAddressOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("meleytvrbitcrjtd")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("mtnjabgipchubpee")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param value
     */
    @JvmName("vajcjnsvkvhjkynl")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): RemoteAddressMatchConditionParametersArgs =
        RemoteAddressMatchConditionParametersArgs(
            matchValues = matchValues,
            negateCondition = negateCondition,
            `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
            transforms = transforms,
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
