@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.RouteConfigurationOverrideActionParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the route configuration override action.
 * @property cacheConfiguration The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
 * @property originGroupOverride A reference to the origin group override configuration. Leave empty to use the default origin group on route.
 * @property typeName
 */
public data class RouteConfigurationOverrideActionParametersArgs(
    public val cacheConfiguration: Output<CacheConfigurationArgs>? = null,
    public val originGroupOverride: Output<OriginGroupOverrideArgs>? = null,
    public val typeName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.RouteConfigurationOverrideActionParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.cdn.inputs.RouteConfigurationOverrideActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.RouteConfigurationOverrideActionParametersArgs.builder()
            .cacheConfiguration(
                cacheConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .originGroupOverride(
                originGroupOverride?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteConfigurationOverrideActionParametersArgs].
 */
@PulumiTagMarker
public class RouteConfigurationOverrideActionParametersArgsBuilder internal constructor() {
    private var cacheConfiguration: Output<CacheConfigurationArgs>? = null

    private var originGroupOverride: Output<OriginGroupOverrideArgs>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
     */
    @JvmName("fuetxugcxgkeeeke")
    public suspend fun cacheConfiguration(`value`: Output<CacheConfigurationArgs>) {
        this.cacheConfiguration = value
    }

    /**
     * @param value A reference to the origin group override configuration. Leave empty to use the default origin group on route.
     */
    @JvmName("vfcjwjvmxbtktevt")
    public suspend fun originGroupOverride(`value`: Output<OriginGroupOverrideArgs>) {
        this.originGroupOverride = value
    }

    /**
     * @param value
     */
    @JvmName("dyenittycuragkpa")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
     */
    @JvmName("gdarddadghiltlcq")
    public suspend fun cacheConfiguration(`value`: CacheConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheConfiguration = mapped
    }

    /**
     * @param argument The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
     */
    @JvmName("quknbkdyjougceav")
    public suspend
    fun cacheConfiguration(argument: suspend CacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CacheConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cacheConfiguration = mapped
    }

    /**
     * @param value A reference to the origin group override configuration. Leave empty to use the default origin group on route.
     */
    @JvmName("cletjthghcwwkksf")
    public suspend fun originGroupOverride(`value`: OriginGroupOverrideArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroupOverride = mapped
    }

    /**
     * @param argument A reference to the origin group override configuration. Leave empty to use the default origin group on route.
     */
    @JvmName("tpncnbsshtsofbui")
    public suspend
    fun originGroupOverride(argument: suspend OriginGroupOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = OriginGroupOverrideArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.originGroupOverride = mapped
    }

    /**
     * @param value
     */
    @JvmName("buykbcdmpcgmcwap")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): RouteConfigurationOverrideActionParametersArgs =
        RouteConfigurationOverrideActionParametersArgs(
            cacheConfiguration = cacheConfiguration,
            originGroupOverride = originGroupOverride,
            typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        )
}
