@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlRewriteActionParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the parameters for the url rewrite action.
 * @property destination Define the relative URL to which the above requests will be rewritten by.
 * @property preserveUnmatchedPath Whether to preserve unmatched path. Default value is true.
 * @property sourcePattern define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
 * @property typeName
 */
public data class UrlRewriteActionParametersArgs(
    public val destination: Output<String>,
    public val preserveUnmatchedPath: Output<Boolean>? = null,
    public val sourcePattern: Output<String>,
    public val typeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlRewriteActionParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlRewriteActionParametersArgs =
        com.pulumi.azurenative.cdn.inputs.UrlRewriteActionParametersArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 }))
            .preserveUnmatchedPath(preserveUnmatchedPath?.applyValue({ args0 -> args0 }))
            .sourcePattern(sourcePattern.applyValue({ args0 -> args0 }))
            .typeName(typeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UrlRewriteActionParametersArgs].
 */
@PulumiTagMarker
public class UrlRewriteActionParametersArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var preserveUnmatchedPath: Output<Boolean>? = null

    private var sourcePattern: Output<String>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Define the relative URL to which the above requests will be rewritten by.
     */
    @JvmName("vreefjggkuvsicqj")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Whether to preserve unmatched path. Default value is true.
     */
    @JvmName("muvaqpjcbyiombri")
    public suspend fun preserveUnmatchedPath(`value`: Output<Boolean>) {
        this.preserveUnmatchedPath = value
    }

    /**
     * @param value define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
     */
    @JvmName("mowryqxhfqdeeisx")
    public suspend fun sourcePattern(`value`: Output<String>) {
        this.sourcePattern = value
    }

    /**
     * @param value
     */
    @JvmName("ktrtrvitrwcjyiyr")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Define the relative URL to which the above requests will be rewritten by.
     */
    @JvmName("epfkcfviojnxohwv")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Whether to preserve unmatched path. Default value is true.
     */
    @JvmName("wsrsvkgtcjnteaji")
    public suspend fun preserveUnmatchedPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveUnmatchedPath = mapped
    }

    /**
     * @param value define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
     */
    @JvmName("ratrggydolyemfrl")
    public suspend fun sourcePattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePattern = mapped
    }

    /**
     * @param value
     */
    @JvmName("rqhgkriuxyfrvwue")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): UrlRewriteActionParametersArgs = UrlRewriteActionParametersArgs(
        destination = destination ?: throw PulumiNullFieldException("destination"),
        preserveUnmatchedPath = preserveUnmatchedPath,
        sourcePattern = sourcePattern ?: throw PulumiNullFieldException("sourcePattern"),
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
    )
}
