@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the cache-key query string action.
 * @property queryParameters query parameters to include or exclude (comma separated).
 * @property queryStringBehavior Caching behavior for the requests
 * @property typeName
 */
public data class CacheKeyQueryStringActionParametersResponse(
    public val queryParameters: String? = null,
    public val queryStringBehavior: String,
    public val typeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.CacheKeyQueryStringActionParametersResponse):
            CacheKeyQueryStringActionParametersResponse = CacheKeyQueryStringActionParametersResponse(
            queryParameters = javaType.queryParameters().map({ args0 -> args0 }).orElse(null),
            queryStringBehavior = javaType.queryStringBehavior(),
            typeName = javaType.typeName(),
        )
    }
}
