@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the RequestBody condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestBody'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestBodyConditionResponse(
    public val name: String,
    public val parameters: RequestBodyMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRequestBodyConditionResponse):
            DeliveryRuleRequestBodyConditionResponse = DeliveryRuleRequestBodyConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.RequestBodyMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
