@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the RequestScheme condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestScheme'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestSchemeConditionResponse(
    public val name: String,
    public val parameters: RequestSchemeMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRequestSchemeConditionResponse):
            DeliveryRuleRequestSchemeConditionResponse = DeliveryRuleRequestSchemeConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.RequestSchemeMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
