@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the ServerPort condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'ServerPort'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleServerPortConditionResponse(
    public val name: String,
    public val parameters: ServerPortMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleServerPortConditionResponse):
            DeliveryRuleServerPortConditionResponse = DeliveryRuleServerPortConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.ServerPortMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
