@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from Azure Front Door.
 * @property deploymentStatus
 * @property healthProbeSettings Health probe settings to the origin that is used to determine the health of the origin.
 * @property id Resource ID.
 * @property loadBalancingSettings Load balancing settings for a backend pool
 * @property name Resource name.
 * @property profileName The name of the profile which holds the origin group.
 * @property provisioningState Provisioning status
 * @property sessionAffinityState Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
 * @property systemData Read only system data
 * @property trafficRestorationTimeToHealedOrNewEndpointsInMinutes Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
 * @property type Resource type.
 */
public data class GetAFDOriginGroupResult(
    public val deploymentStatus: String,
    public val healthProbeSettings: HealthProbeParametersResponse? = null,
    public val id: String,
    public val loadBalancingSettings: LoadBalancingSettingsParametersResponse? = null,
    public val name: String,
    public val profileName: String,
    public val provisioningState: String,
    public val sessionAffinityState: String? = null,
    public val systemData: SystemDataResponse,
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetAFDOriginGroupResult):
            GetAFDOriginGroupResult = GetAFDOriginGroupResult(
            deploymentStatus = javaType.deploymentStatus(),
            healthProbeSettings = javaType.healthProbeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.HealthProbeParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            loadBalancingSettings = javaType.loadBalancingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.LoadBalancingSettingsParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            profileName = javaType.profileName(),
            provisioningState = javaType.provisioningState(),
            sessionAffinityState = javaType.sessionAffinityState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            trafficRestorationTimeToHealedOrNewEndpointsInMinutes = javaType.trafficRestorationTimeToHealedOrNewEndpointsInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
