@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Friendly Secret name mapping to the any Secret or secret related information.
 * @property deploymentStatus
 * @property id Resource ID.
 * @property name Resource name.
 * @property parameters object which contains secret parameters
 * @property profileName The name of the profile which holds the secret.
 * @property provisioningState Provisioning status
 * @property systemData Read only system data
 * @property type Resource type.
 */
public data class GetSecretResult(
    public val deploymentStatus: String,
    public val id: String,
    public val name: String,
    public val parameters: Any? = null,
    public val profileName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetSecretResult):
            GetSecretResult = GetSecretResult(
            deploymentStatus = javaType.deploymentStatus(),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
            profileName = javaType.profileName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
