@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the url rewrite action.
 * @property destination Define the relative URL to which the above requests will be rewritten by.
 * @property preserveUnmatchedPath Whether to preserve unmatched path. Default value is true.
 * @property sourcePattern define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
 * @property typeName
 */
public data class UrlRewriteActionParametersResponse(
    public val destination: String,
    public val preserveUnmatchedPath: Boolean? = null,
    public val sourcePattern: String,
    public val typeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlRewriteActionParametersResponse):
            UrlRewriteActionParametersResponse = UrlRewriteActionParametersResponse(
            destination = javaType.destination(),
            preserveUnmatchedPath = javaType.preserveUnmatchedPath().map({ args0 -> args0 }).orElse(null),
            sourcePattern = javaType.sourcePattern(),
            typeName = javaType.typeName(),
        )
    }
}
