@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the url rewrite action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'UrlRewrite'.
 * @property parameters Defines the parameters for the action.
 */
public data class UrlRewriteActionResponse(
    public val name: String,
    public val parameters: UrlRewriteActionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlRewriteActionResponse):
            UrlRewriteActionResponse = UrlRewriteActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.UrlRewriteActionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
