@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AppServiceCertificateOrderCertificate].
 */
@PulumiTagMarker
public class AppServiceCertificateOrderCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppServiceCertificateOrderCertificateArgs =
        AppServiceCertificateOrderCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend AppServiceCertificateOrderCertificateArgsBuilder.() -> Unit) {
        val builder = AppServiceCertificateOrderCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AppServiceCertificateOrderCertificate {
        val builtJavaResource =
            com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppServiceCertificateOrderCertificate(builtJavaResource)
    }
}

/**
 * Key Vault container ARM resource for a certificate that is purchased through Azure.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceCertificateOrderCertificate = new AzureNative.CertificateRegistration.AppServiceCertificateOrderCertificate("appServiceCertificateOrderCertificate", new()
 *     {
 *         CertificateOrderName = "SampleCertificateOrderName",
 *         KeyVaultId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName",
 *         KeyVaultSecretName = "SampleSecretName1",
 *         Location = "Global",
 *         Name = "SampleCertName1",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/certificateregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := certificateregistration.NewAppServiceCertificateOrderCertificate(ctx, "appServiceCertificateOrderCertificate", &certificateregistration.AppServiceCertificateOrderCertificateArgs{
 * 			CertificateOrderName: pulumi.String("SampleCertificateOrderName"),
 * 			KeyVaultId:           pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 * 			KeyVaultSecretName:   pulumi.String("SampleSecretName1"),
 * 			Location:             pulumi.String("Global"),
 * 			Name:                 pulumi.String("SampleCertName1"),
 * 			ResourceGroupName:    pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificate;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceCertificateOrderCertificate = new AppServiceCertificateOrderCertificate("appServiceCertificateOrderCertificate", AppServiceCertificateOrderCertificateArgs.builder()
 *             .certificateOrderName("SampleCertificateOrderName")
 *             .keyVaultId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName")
 *             .keyVaultSecretName("SampleSecretName1")
 *             .location("Global")
 *             .name("SampleCertName1")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:certificateregistration:AppServiceCertificateOrderCertificate SampleCertName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}
 * ```
 */
public class AppServiceCertificateOrderCertificate internal constructor(
    override val javaResource:
    com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificate,
) : KotlinCustomResource(javaResource, AppServiceCertificateOrderCertificateMapper) {
    /**
     * Key Vault resource Id.
     */
    public val keyVaultId: Output<String>?
        get() = javaResource.keyVaultId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key Vault secret name.
     */
    public val keyVaultSecretName: Output<String>?
        get() = javaResource.keyVaultSecretName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of the Key Vault secret.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppServiceCertificateOrderCertificateMapper :
    ResourceMapper<AppServiceCertificateOrderCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificate::class == javaResource::class

    override fun map(javaResource: Resource): AppServiceCertificateOrderCertificate =
        AppServiceCertificateOrderCertificate(
            javaResource as
                com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificate,
        )
}

/**
 * @see [AppServiceCertificateOrderCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServiceCertificateOrderCertificate].
 */
public suspend fun appServiceCertificateOrderCertificate(
    name: String,
    block: suspend AppServiceCertificateOrderCertificateResourceBuilder.() -> Unit,
):
    AppServiceCertificateOrderCertificate {
    val builder = AppServiceCertificateOrderCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServiceCertificateOrderCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServiceCertificateOrderCertificate(name: String):
    AppServiceCertificateOrderCertificate {
    val builder = AppServiceCertificateOrderCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
