@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.inputs

import com.pulumi.azurenative.certificateregistration.inputs.AppServiceCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Key Vault container for a certificate that is purchased through Azure.
 * @property keyVaultId Key Vault resource Id.
 * @property keyVaultSecretName Key Vault secret name.
 */
public data class AppServiceCertificateArgs(
    public val keyVaultId: Output<String>? = null,
    public val keyVaultSecretName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.certificateregistration.inputs.AppServiceCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.certificateregistration.inputs.AppServiceCertificateArgs =
        com.pulumi.azurenative.certificateregistration.inputs.AppServiceCertificateArgs.builder()
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultSecretName(keyVaultSecretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServiceCertificateArgs].
 */
@PulumiTagMarker
public class AppServiceCertificateArgsBuilder internal constructor() {
    private var keyVaultId: Output<String>? = null

    private var keyVaultSecretName: Output<String>? = null

    /**
     * @param value Key Vault resource Id.
     */
    @JvmName("oxafjivopqfwwdyx")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value Key Vault secret name.
     */
    @JvmName("ghgvnyxhplpsfrdk")
    public suspend fun keyVaultSecretName(`value`: Output<String>) {
        this.keyVaultSecretName = value
    }

    /**
     * @param value Key Vault resource Id.
     */
    @JvmName("fvdrbrljxwcixvpm")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value Key Vault secret name.
     */
    @JvmName("bshvxdsellvmgckq")
    public suspend fun keyVaultSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretName = mapped
    }

    internal fun build(): AppServiceCertificateArgs = AppServiceCertificateArgs(
        keyVaultId = keyVaultId,
        keyVaultSecretName = keyVaultSecretName,
    )
}
