@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.inputs

import com.pulumi.azurenative.changeanalysis.inputs.AzureMonitorWorkspacePropertiesArgs.builder
import com.pulumi.azurenative.changeanalysis.kotlin.enums.ChangeDetailsMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration properties of an Azure Monitor workspace that receives change notifications.
 * @property includeChangeDetails The mode of includeChangeDetails feature. The flag configures whether to include or exclude content of the change before and after values.
 * @property workspaceId The Azure Monitor workspace ID - the unique identifier for the Log Analytics workspace.
 * @property workspaceResourceId The Azure Monitor workspace ARM Resource ID. The resource ID should be in the following format: /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}
 */
public data class AzureMonitorWorkspacePropertiesArgs(
    public val includeChangeDetails: Output<Either<String, ChangeDetailsMode>>? = null,
    public val workspaceId: Output<String>? = null,
    public val workspaceResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.changeanalysis.inputs.AzureMonitorWorkspacePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.changeanalysis.inputs.AzureMonitorWorkspacePropertiesArgs =
        com.pulumi.azurenative.changeanalysis.inputs.AzureMonitorWorkspacePropertiesArgs.builder()
            .includeChangeDetails(
                includeChangeDetails?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMonitorWorkspacePropertiesArgs].
 */
@PulumiTagMarker
public class AzureMonitorWorkspacePropertiesArgsBuilder internal constructor() {
    private var includeChangeDetails: Output<Either<String, ChangeDetailsMode>>? = null

    private var workspaceId: Output<String>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value The mode of includeChangeDetails feature. The flag configures whether to include or exclude content of the change before and after values.
     */
    @JvmName("ayyevhrxgtmissft")
    public suspend fun includeChangeDetails(`value`: Output<Either<String, ChangeDetailsMode>>) {
        this.includeChangeDetails = value
    }

    /**
     * @param value The Azure Monitor workspace ID - the unique identifier for the Log Analytics workspace.
     */
    @JvmName("svciovrnpxuvwlmj")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The Azure Monitor workspace ARM Resource ID. The resource ID should be in the following format: /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}
     */
    @JvmName("ckfkhrwtjlftjaaq")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value The mode of includeChangeDetails feature. The flag configures whether to include or exclude content of the change before and after values.
     */
    @JvmName("cqjpqsbrkbuwaanc")
    public suspend fun includeChangeDetails(`value`: Either<String, ChangeDetailsMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeChangeDetails = mapped
    }

    /**
     * @param value The mode of includeChangeDetails feature. The flag configures whether to include or exclude content of the change before and after values.
     */
    @JvmName("prynmnpvyxuamdhr")
    public fun includeChangeDetails(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChangeDetailsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeChangeDetails = mapped
    }

    /**
     * @param value The mode of includeChangeDetails feature. The flag configures whether to include or exclude content of the change before and after values.
     */
    @JvmName("rqmuqtofnywuraul")
    public fun includeChangeDetails(`value`: ChangeDetailsMode) {
        val toBeMapped = Either.ofRight<String, ChangeDetailsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeChangeDetails = mapped
    }

    /**
     * @param value The Azure Monitor workspace ID - the unique identifier for the Log Analytics workspace.
     */
    @JvmName("wmunvcsjwcjhmgjt")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    /**
     * @param value The Azure Monitor workspace ARM Resource ID. The resource ID should be in the following format: /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}
     */
    @JvmName("wghmofgpibuqkjex")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): AzureMonitorWorkspacePropertiesArgs = AzureMonitorWorkspacePropertiesArgs(
        includeChangeDetails = includeChangeDetails,
        workspaceId = workspaceId,
        workspaceResourceId = workspaceResourceId,
    )
}
