@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.inputs

import com.pulumi.azurenative.changeanalysis.inputs.GetConfigurationProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName The name of the configuration profile. The profile name should be set to 'default', all other names will be overwritten.
 */
public data class GetConfigurationProfilePlainArgs(
    public val profileName: String,
) : ConvertibleToJava<com.pulumi.azurenative.changeanalysis.inputs.GetConfigurationProfilePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.changeanalysis.inputs.GetConfigurationProfilePlainArgs =
        com.pulumi.azurenative.changeanalysis.inputs.GetConfigurationProfilePlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfilePlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfilePlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    /**
     * @param value The name of the configuration profile. The profile name should be set to 'default', all other names will be overwritten.
     */
    @JvmName("odsobgypbqewakcq")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    internal fun build(): GetConfigurationProfilePlainArgs = GetConfigurationProfilePlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
    )
}
